<!doctype html>
<html lang="pt-br">

<?php $this->load->view('includes/incHead'); ?>

<body>
    <script type="text/javascript">
    var dataLayer = [];
    var info_produto = [];
    var id_produto = null;
    var user_hash = '';
</script>


<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        '//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-KVFWJTB');</script>
<!-- End Google Tag Manager -->


    <div class="page-container">


<?php $this->load->view('includes/incHeader'); ?>


                <main class="main-container">
<section class="faq-container bc-darkwhite" >
    <div class="section-container" >
        <header class="section-header tc-darkblue ta-center" >
            <h2 class="section-title fw-normal" ><strong>FAQ</strong> - Perguntas Frequentes</h2>
            <p class="section-description" >Confira as principais dúvidas de quem<br>procura o Ehbooks.</p>
        </header>
        <ul class="faq-list" >
        	<?php foreach ($lista as $key => $row) { ?>
            <li class="faq-list-item" >
                <div class="tw-accordion" >
                    <input type="checkbox" class="tw-accordion-check check-unique" id="faq-<?php echo $key; ?>" name="tw-faq" />
                    <label class="tw-accordion-label" for="faq-<?php echo $key; ?>" >
                        <h3 class="tw-accordion-title" >
                            <?php echo strip_tags($row->pergunta); ?>
                        </h3>
                    </label>
                    <div class="tw-accordion-body" >
                    	<?php echo ($row->resposta); ?>
                    </div>
                </div>
            </li>
            <?php } ?>
            
            
            
            
        </ul>
        <!--div class="ta-center mt-40 mb-40" >
            <a href="https://www.avmakers.com.br/contato" class="tw-btn default upper" >Tenho outra(s) dúvida(s)</a>
        </div-->
    </div>

            <form id="form-faq" name="form-faq" class="contact-form tw-form">
                    <div class="form-input-container">
                        <input value="" type="text" name="nome" class="form-input" id="nome" placeholder="Digite seu nome">
                        <label for="tw-contact-nome" class="form-label">Nome</label>
                    </div>
                    <span class="mensagem-alerta" id="nomeStatus"></span><br/>
                    
                <div class="form-input-container">
                	<input value="" type="email" name="email" class="form-input" id="email" placeholder="Digite seu e-mail">
                    <label for="tw-contact-email" class="form-label">E-mail</label>
                </div>
                <span class="mensagem-alerta" id="emailStatus"></span><br/>

                    <div class="form-input-container">
                    	<select class="form-input" id="categoria" name="categoria">
							<option value="">Selecione uma categoria</option>
							<?php foreach($categoria as $row){ ?>
								<option value="<?php echo $row->id;?>"><?php echo $row->nome;?></option>
							<?php } ?>
						</select>
                        <label for="tw-contact-categoria" class="form-label">Categoria</label>
                    </div>
                    <span class="mensagem-alerta" id="categoriaStatus"></span><br/>

                <div class="form-input-container">
                    <textarea name="pergunta" rows="5" class="form-input textarea" id="pergunta" placeholder="Digite sua pergunta..." ></textarea>
                    <label for="tw-contact-mensagem" class="form-label">Pergunta</label>
                </div>
                <span class="mensagem-alerta" id="perguntaStatus"></span><br/>

                <div style="text-align: center;" class="submit-container">
                	<div id="msnStatus"></div>
                    <button type="button" id="submit-faq" class="tw-btn success upper">Enviar Mensagem</button>
                </div>
            </form>

</section>

        </main>

<?php $this->load->view('includes/incFooter'); ?>

            </div>

<?php $this->load->view('includes/incScripts'); ?>

</body>
</html>


<script>
$(document).ready(function() {
    $("#submit-faq").click(function(){
	    $('#emailStatus').html("");
        $('#nomeStatus').html("");
        $('#perguntaStatus').html("");
        var isValid = true;
        var msgForm = "";
        $('#messageStatus').html(msgForm);
        var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        if(!emailReg.test($('#form-faq [name=email]').val()) && $('#email').val() != ""){
            isValid = false;
            $('#emailStatus').html("E-mail Inválido. Tente novamente.<br />");
        }
        if($('#form-faq [name=email]').val() == ""){
            isValid = false;
            $('#emailStatus').html("E-mail é um campo obrigatório.<br />");
        }
        if($('#form-faq [name=nome]').val() == ""){
            isValid = false;
            $('#nomeStatus').html("Nome é um campo obrigatório.<br />");
        }
        if($('#form-faq [name=categoria]').val() == ""){
            isValid = false;
            $('#categoriaStatus').html("Categoria é um campo obrigatório.<br />");
        }
        if($('#form-faq [name=pergunta]').val() == ""){
            isValid = false;
            $('#perguntaStatus').html("Pergunta é um campo obrigatório.<br />");
        }
        if(isValid){
            $('#form-faq').ajaxSubmit({
                beforeSerialize: function() {
                	$(".jquery-waiting-base-container").waitingShow({modo:"slow"});
                	},
                type:  'POST',
                url: "<?php echo base_url();?>faq/salvar",
                success: function(resposta) { 
                    $('#form-faq').html("<center><h4 class='color_green'>Sua pergunta foi cadastrada com sucesso, por favor aguarde moderação.</h4></center>");
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
    				//$('#timerstart').html("<center><h6>Você está sendo redirecionado para a página de produtos em <span class='count'>5</span> segundos.</h6></center>");
            		//starttime('<?php echo base_url().'produto'; ?>', 5);
                },
                error: function (xhr, ajaxOptions, thrownError){
                    //xhr.status : 404, 303, 501...
                    var error = null;
                    switch(xhr.status)
                    {
                        case "301":
                            error = "Erro de redirecionamento.";
                            break;
                        case "307":
                            error = "Erro, redirecionamento de servidor temporário.";
                            break;
                        case "400":
                            error = "Solicitação ruim.";
                            break;
                        case "404":
                            error = "Página não encontrada.";
                            break;
                        case "500":
                            error = "Servidor indisponível no momento.";
                            break;
                        default:
                            error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                    }
                    if(error){
                        $('#messageStatus').html("<center><h4 class='color_red'>"+error+"</h4></center>");
                        $(".jquery-waiting-base-container").waiting({modo:"slow"});
                    }
                }
            });
        }else{
            $('#messageStatus').html("<center><h4 class='color_red'>"+msgForm+"</h4></center>");
        }
    });

});

</script>

<style>
	.mensagem-alerta{
		color: red;
	}
</style>

</body>
</html>
