<?php

class Pagamentomodel extends CI_Model {

    function __construct(){
        // Chama o construtor do Model
        parent::__construct();
    }

    public function configuracao(){
        $query = $this->db->query("SELECT * FROM configuracao cgc INNER JOIN unidade und ON cgc.unidade = und.id");
        return $query->result();        
    }

    public function pagamentoforma($id){
    	$sql = "SELECT * FROM pagamentoforma WHERE id = '$id'";
		//echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function pagamentoTotal($usuario='', $carrinho=''){
    	if($carrinho){
    		$sqlwhere = "car.id = '$carrinho'";
    	}else{
    		$sqlwhere = "car.usuario = '$usuario'";
    	}
    	$sql = "SELECT car.usuario, sum(car.valor) total, sum(car.frete) totalfrete 
            FROM carrinho car 
            INNER JOIN produto prd ON prd.id = car.produto 
            WHERE $sqlwhere
            order by car.id desc
            limit 1";
        //echo "<pre>";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function carrinho($usuario='', $carrinho=''){
    	if($carrinho){
    		$sqlwhere = "car.id = '$carrinho'";
    	}else{
    		$sqlwhere = "car.usuario = '$usuario'";
    	}
    	$sql = "SELECT crs.id cursoid, crs.tipo cursotipo, prd.titulo, prd.qtdade_saldo, prd.qtdade_porcompra, cup.id cupomid, cup.cupom cupomproduto, car.* 
            FROM carrinho car 
            INNER JOIN produto prd ON prd.id = car.produto 
            LEFT JOIN cupom cup ON cup.cupom LIKE BINARY car.cupom AND cup.status = '1'
            LEFT JOIN curso crs ON crs.id = prd.curso AND crs.data_expiracao >= NOW() AND crs.status = '1'
            WHERE $sqlwhere";
        //echo "<pre>";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }
	
    public function emailfrom(){
        $query = $this->db->get_where('referenciamento', array('id' => '6'));
        return $query->result();        
    }

    public function emailto(){
        $query = $this->db->get_where('referenciamento', array('id' => '16'));
        return $query->result();        
    }
	
    public function itemingressos($pedidoitem){
        $query = $this->db->query("SELECT pig.*, pit.preco, pep.id particid, pep.nome particnome, pep.nascimento particnascimento, pep.email particemail, pep.telefone partictelefone, pep.cpf paticcpf, pep.enviar
			FROM pedidoitem_ingresso pig 
			INNER JOIN pedidoitem pit ON pit.id = pig.pedidoitem 
			INNER JOIN pedido ped ON ped.id = pit.pedido
			LEFT JOIN pedidoitem_participante pep ON pep.pedidoitem_ingresso = pig.id
			WHERE pit.id = '$pedidoitem'");
        return $query->result();        
    }
    
    function item($usuario='', $carrinho=''){
    	if($carrinho){
    		$sqlwhere = "car.id = '$carrinho'";
    	}else{
    		$sqlwhere = "car.usuario = '$usuario'";
    	}
    	$sql = "SELECT car.*, cup.id cupomid, cup.cupom cupomproduto, cup.qtdade cupom_qtdade, cup.utilizado cupom_utilizado, cup.desconto cupom_desconto, prd.titulo produtonome, 
			prd.qtdade_vendida, prd.qtdade_saldo, prd.obs, prd.tipo, prd.tiponota, prd.evento, prd.obs, prd.ncm, evc.descricao eventolocal, 
			evt.titulo eventotitulo, evt.data_inicio, evt.hora_inicio, evt.data_fim, evt.hora_fim, 
			caf.id freteid, caf.endereco, caf.bairro, caf.cidade, caf.uf, caf.cep, crs.titulo cursonome, crs.id cursoid, crs.tipo cursotipo,
			und.cielo_numero, und.cielo_chave, und.id undid, und.nome undnome, und.telefone undtelefone, und.endereco undendereco
			FROM carrinho car 
			INNER JOIN produto prd ON prd.id = car.produto
			LEFT JOIN carrinho_frete caf ON caf.carrinho = car.id
			LEFT JOIN agenda evt ON evt.id = prd.evento
			LEFT JOIN agenda_campo evc ON evc.agenda = evt.id AND UPPER(evc.rotulo) = UPPER('onde')
			LEFT JOIN cupom cup ON cup.cupom LIKE BINARY car.cupom AND cup.status = '1'
			LEFT JOIN curso crs ON crs.id = prd.curso
			LEFT JOIN unidade und ON und.id = car.unidade
			WHERE $sqlwhere";
		//echo "<pre>";
		//echo $sql;
		//exit;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    function produto($produto){
        $query = $this->db->query("SELECT prd.*, evc.descricao eventolocal, evt.titulo eventotitulo, evt.data_inicio, evt.hora_inicio, evt.data_fim, evt.hora_fim
            FROM produto prd
            LEFT JOIN agenda evt ON evt.id = prd.evento 
            LEFT JOIN agenda_campo evc ON evc.agenda = evt.id AND UPPER(evc.rotulo) = UPPER('onde')
            WHERE prd.id = '$produto'");
        return $query->result();        
    }

    function usuario($usuario){
        $sql = "SELECT *
            FROM adminacesso usu
            left join loja_usuario lju on lju.usuario = usu.id
            WHERE usu.id = '$usuario'";
        //echo "<pre>";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    function produtocombo($produto){
        $query = $this->db->query("SELECT cmb.*
            FROM produto prd
            inner join produto_combo ptc on ptc.produto = prd.id
            inner join produto cmb on cmb.id = ptc.produto_combo
            WHERE prd.id = '$produto'");
        return $query->result();        
    }

    public function status($status){
        $query = $this->db->query("SELECT * FROM pedido_status WHERE id = '$status'");
        return $query->result();        
    }
    
    public function pedido($tid='', $pedido=''){
        if($tid){
        	$sqlcomplemento = "WHERE ped.tid = '$tid'";
        }else{
        	$sqlcomplemento = "WHERE ped.id = '$pedido'";
        }
        $sql = "SELECT ped.*, pgf.descricao pagamentoforma, pes.nome statusnome, 
            usu.nome usuarionome, usu.email, lur.endereco, usu.pessoa, usu.cpf, lur.ie, lur.endereco, '0' numero, lur.bairro, lur.cep, lur.cidade, lur.uf, lur.pais, 
            usu.telcel
            FROM pedido ped 
            INNER JOIN pagamentoforma pgf ON pgf.id = ped.pagamentoforma
            INNER JOIN pedido_status pes ON pes.id = ped.status
            INNER JOIN adminacesso usu ON usu.id = ped.usuario
            LEFT JOIN loja_usuario lur ON lur.usuario = usu.id
            $sqlcomplemento";
        //echo "<pre>";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function pedidoitem($pedido){
        $sql = "SELECT prd.titulo produtonome, prd.qtdade_vendida, prd.qtdade_bloqueada, prd.qtdade_saldo, prd.obs, evt.id evento,
            cup.id cupomid, cup.cupom cupomproduto, cup.qtdade cupom_qtdade, cup.utilizado cupom_utilizado, cup.desconto cupom_desconto,
            evt.data_inicio, evt.hora_inicio, evt.data_fim, evt.hora_fim, evt.titulo eventotitulo, evc.descricao eventolocal, pei.*,
            crs.titulo cursonome, crs.id cursoid, crs.tipo cursotipo
            FROM pedidoitem pei 
            INNER JOIN produto prd ON prd.id = pei.produto
            LEFT JOIN cupom cup ON cup.cupom LIKE BINARY pei.cupom AND cup.status = '1'
            LEFT JOIN agenda evt ON evt.id = prd.evento
            LEFT JOIN agenda_campo evc ON evc.agenda = evt.id AND UPPER(evc.rotulo) = UPPER('onde')
            LEFT JOIN curso crs ON crs.id = prd.curso
            WHERE pei.pedido = '$pedido'";
		//echo "<pre>";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function pedidoitemformulario($item){
        $sql = "SELECT crf.*, pcf.label
            FROM pedidoitem_formulario crf
            INNER JOIN produto_categoria_formulario pcf ON pcf.id = crf.campo
            WHERE crf.pedidoitem = '$item'
            ORDER BY crf.id";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function pedidofrete($pedido){
        $sql = "SELECT pdf.*
            FROM pedido_frete pdf 
            WHERE pdf.pedido = '$pedido'";
		//echo "<pre>";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function itempaticipante($item, $numero){
        $sql = "SELECT * FROM carrinho_participante WHERE carrinho = '$item' AND numero = '$numero'";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function itempresente($item){
        $sql = "SELECT * FROM carrinho_presente WHERE carrinho = '$item'";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function pedidoitempresente($item){
        $sql = "SELECT * FROM pedidoitem_presente WHERE pedidoitem = '$item'";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function itemformulario($item){
        $sql = "SELECT crf.*, pcf.label
            FROM carrinho_formulario crf
            INNER JOIN produto_categoria_formulario pcf ON pcf.id = crf.campo
            WHERE crf.carrinho = '$item'
            ORDER BY crf.id";
        //echo $sql;
        $query = $this->db->query($sql);
        return $query->result();        
    }

    public function addPedido($tid, $valor_total, $forma_pagamento='', $status='1', $carrinho=''){
    	//echo ($forma_pagamento);
    	
		$this->load->library('cidompdf');
        	
        $retorno = false;
        $tid = $tid."";
        $emailto = $this->emailto();
        $emailfrom = $this->emailfrom();
        $configuracao = $this->configuracao();
	    
		$mes_ext[1] = "Janeiro";
		$mes_ext[2] = "Fevereiro";
		$mes_ext[3] = "Março";
		$mes_ext[4] = "Abril";
		$mes_ext[5] = "Maio";
		$mes_ext[6] = "Junho";
		$mes_ext[7] = "Julho";
		$mes_ext[8] = "Agosto";
		$mes_ext[9] = "Setembro";
		$mes_ext[10] = "Outubro";
		$mes_ext[11] = "Novembro";
		$mes_ext[12] = "Dezembro";
          
      	$pagamentoforma = $this->pagamentoforma($forma_pagamento);  
		$this->db->set('pagamentoforma', $pagamentoforma[0]->id); 
		
		$pagamentoTotal = $this->pagamentoTotal($this->session->userdata('id'), $carrinho);
		
		if($this->session->userdata('id')) $usuario = $this->usuario($this->session->userdata('id')); else $usuario = $this->usuario($pagamentoTotal[0]->usuario);
		//echo $usuario[0]->id."<br>";
		
        $this->db->set('tid', $tid);
        $this->db->set('usuario', $usuario[0]->id);
        $this->db->set('descricao', "");
        $this->db->set('data', date("Y-m-d"));
        $this->db->set('vencimento', date("Y-m-d"));  
        $this->db->set('datapagamento', date("Y-m-d"));  
        $this->db->set('valorproduto', $pagamentoTotal[0]->total);
        $this->db->set('valor', $valor_total);
		if($pagamentoforma[0]->tipodesacr == '1'){
			$this->db->set('desconto', $valor_total*$pagamentoforma[0]->desacr/100);
		}elseif($pagamentoforma[0]->tipodesacr == '2'){
			$this->db->set('desconto', $pagamentoforma[0]->desacr);
		}elseif($pagamentoforma[0]->tipodesacr == '3'){
			$this->db->set('acrescimo', $valor_total*$pagamentoforma[0]->desacr/100);
		}elseif($pagamentoforma[0]->tipodesacr == '4'){
			$this->db->set('acrescimo', $pagamentoforma[0]->desacr);
		}
        $this->db->set('frete', $pagamentoTotal[0]->totalfrete);
        $this->db->set('valorpago', $valor_total);
        $this->db->set('status', $status);
        
        if($this->db->insert('pedido')){
			
            $pedido = $this->db->insert_id();
            
            $enviodata = date("Y-m-d H:m");
            $enviodescricao = "Em preparação";

		  	$this->db->set('data', $enviodata);
        	$this->db->set('descricao', $enviodata);
        	$this->db->set('pedido', $pedido);
            $this->db->insert('pedido_envio');

			$pedidoadmintitulo = "";
			$pedidotitulo = "";
			$tituloingresso = "";
			$pedidoformulariocorpo = "";
			$tituloparticipantes = "";
			$pedidocorpo = "";
			$presentecorpo = "";
			$fretecorpo = "";
			$pedidoobscorpo = "";
			$ingressocorpo = "";
			$corpoparticipantes = "";
			$pedidomensagem = "";
			$pedidoadminmensagem = "";

			$itemfrete = $this->item($this->session->userdata('id'), $carrinho);
			
			if($itemfrete[0]->freteid){
		        $this->db->set('pedido', $pedido);
		        $this->db->set('endereco', $itemfrete[0]->endereco);
		        $this->db->set('bairro', $itemfrete[0]->bairro);
		        $this->db->set('cidade', $itemfrete[0]->cidade);
		        $this->db->set('uf', $itemfrete[0]->uf);
		        $this->db->set('cep', $itemfrete[0]->cep);
		        if($this->db->insert('pedido_frete')){
		        	$this->db->where('usuario', $usuario[0]->id);
					$this->db->delete('carrinho_frete');
					$pedidoadmintitulo .= "
					Data da compra: ".date("d")." de ".$mes_ext[date("n")]." de ".date("Y")." às ".date("H:i")."<br/>
	            	Assunto: [Site ".$configuracao[0]->nome_projeto."] Compra de produto com endereço de entrega<br/><br/>
	            
	            	---------- Mensagem ----------<br/><br/>
	            	Seguem abaixo os dados da compra no site ".$configuracao[0]->nome_projeto.":<br/><br/>
	            	";
					$fretecorpo .= "
					Abaixo seguem os dados de entrega: <br/><br/>
					<strong>Endereço:</strong> ".$itemfrete[0]->endereco."<br/>
					<strong>Bairro:</strong> ".$itemfrete[0]->bairro."<br/>
					<strong>Cidade/UF:</strong> ".$itemfrete[0]->cidade."/".$itemfrete[0]->uf."<br/>
					<strong>CEP:</strong> ".$itemfrete[0]->cep."<br/><br/>";
					
		        }				
			}

			$pedidostatus = $this->status($status);

	        $pedidotitulo .= "Olá ".$usuario[0]->nome.",<br/><br/>
	        Seguem abaixo os dados da sua compra no site ".$configuracao[0]->nome_projeto.":<br/><br/>";
			
	        $pedidocorpo .= "
	        <strong>Forma de pagamento:</strong> ".$pagamentoforma[0]->descricao."<br/>
	        <strong>Nome do comprador:</strong> ".$usuario[0]->nome."<br/>";
			
	       	if($pagamentoTotal[0]->totalfrete > 0){
		        $pedidocorpo .= "<strong>Valor total dos produtos:</strong> R$ ".$pagamentoTotal[0]->total."<br/>
		        <strong>Taxa de entrega:</strong> R$ ".$pagamentoTotal[0]->totalfrete."<br/>";
	       	}
			
	        $pedidocorpo .= "<strong>Valor total da compra:</strong> R$ ".number_format($valor_total, 2, ',', '.')."<br/>
	        <strong>Status da compra:</strong> ".$pedidostatus[0]->nome."<br/><br/>
	        $fretecorpo
	        <strong>Dados do produto:</strong><br/>";
	        
	         $item = $this->item($this->session->userdata('id'), $carrinho);
			
            foreach ($item as $row) {

                if($row->cursoid && $row->cursotipo == '1' && $status == '1'){
                    
                    $usunome = explode(" ", $usuario[0]->nome);
                    $cursoid = md5($row->cursoid);
                
                    $corpocurso = "
                	Prezado(a) ".$usunome[0].",<br/><br/>
                	
                	Para acessar o curso ".$row->cursonome." clique no link a seguir ou copie a url na barra de endereços do seu navegador: 
                	
                	".base_url("login/curso/".$cursoid)."<br/><br/>
                	
                	".$configuracao[0]->assinatura_nome."<br/>
                	".$configuracao[0]->assinatura_link;
                
                	if($usuario[0]->id){
                        $this->load->library('email');
                        $config['mailtype'] = 'html';
                        $this->email->initialize($config);
                        	        
                        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
                        $this->email->to($usuario[0]->email);
                
                        $this->email->subject("Acesso ao curso ".$row->cursonome." do site ".$configuracao[0]->nome_projeto);
                        $this->email->message($corpocurso);	
                
                        $this->email->send();
                	}
                
                }
					
            	$tokenitem = md5($row->produto.time());
                $this->db->set('pedido', $pedido);
                $this->db->set('produto', $row->produto);
                $this->db->set('unidade', $row->undid);
                $this->db->set('filiacao', $row->filiacao);
                $this->db->set('qtdade', $row->qtdade);
                $this->db->set('preco', $row->valorunitario);
                $this->db->set('valor', $row->valor);
                $this->db->set('cupom', $row->cupom);
                $this->db->set('token', $tokenitem);
				
                $pedidocorpo .= "
                <b>Descrição: </b>".$row->produtonome."<br>
                <b>Preço: </b> R$ ".str_replace(".", ",", $row->valorunitario)."<br>
                <b>Quantidade: </b>".$row->qtdade."<br>
                <b>Total: </b> R$ ".str_replace(".", ",", $row->valor)."<br><br>
                <strong>Dados de envio:</strong><br>
                <strong>".date("d/m/Y H:m", strtotime($enviodata))."&nbsp;&nbsp;&nbsp;===>&nbsp;&nbsp;&nbsp;".$enviodescricao."</strong><br/>";
				
				if($row->obs){
		            $pedidoobscorpo .= '<br/><strong>Observações adicionais e instruções: </strong><br/>'.$row->obs;
				}
				
                if ($this->db->insert('pedidoitem')){
                	$pedidoitem = $this->db->insert_id();

                	$itemformulario = $this->itemformulario($row->id);

					if(!empty($itemformulario)){
						
						$pedidoformulariocorpo .= "<br/>Dados complementares da compra:<br/><br/>";					
						foreach ($itemformulario as $key => $rowform) {
                            $this->db->set('pedidoitem', $pedidoitem);
                            $this->db->set('campo', $rowform->campo);
                            $this->db->set('descricao', $rowform->descricao);
                            if($this->db->insert('pedidoitem_formulario')){
                                $this->db->where("id", $rowform->id);
                                $this->db->delete("carrinho_formulario");
                            }
                            $pedidoformulariocorpo .= "<b>".$rowform->label.":</b> ".$rowform->descricao."<br/>";
						}
						$pedidoformulariocorpo .= "<br/>";
					}


                	$itempresente = $this->itempresente($row->id);

					if(!empty($itempresente)){
		                $this->db->set('pedidoitem', $pedidoitem);
		                $this->db->set('nome', $itempresente[0]->nome);
		                $this->db->set('nascimento', $itempresente[0]->nascimento);
		                $this->db->set('email', $itempresente[0]->email);
		                $this->db->set('telefone', $itempresente[0]->telefone);
		                $this->db->set('cpf', $itempresente[0]->cpf);
		                $this->db->set('enviar', $itempresente[0]->enviar);
		                $this->db->set('mensagem', $itempresente[0]->mensagem);
		                if($this->db->insert('pedidoitem_presente')){
		                    $this->db->where("id", $itempresente[0]->id);
		                    $this->db->delete("carrinho_presente");
		                }	
						if($status == '1'){
							
							if(!$itempresente[0]->nascimento || $itempresente[0]->nascimento == "0000-00-00"){
								$nascimento = "Data de nascimento não preenchida";
							}else{
								$nascimento = date("d/m/Y", strtotime($itempresente[0]->nascimento));
							}
							if($itempresente[0]->cpf){
								$cpf = $itempresente[0]->cpf;
							}else{
								$cpf = "CPF não preenchido";
							}
							$pedidoobscorpo .= "<br/>Abaixo seguem os dados da pessoa que receberá este produto como presente:<br/><br/>
												<b>Nome:</b> ".$itempresente[0]->nome."<br/>
												<b>Data de nascimento:</b> ".$nascimento."<br/>
												<b>E-mail:</b> ".$itempresente[0]->email."<br/>
												<b>Telefone:</b> ".$itempresente[0]->telefone."<br/>
												<b>CPF:</b> ".$cpf."<br/>";
						}
					}
					
                	if($status == '1'){
	                    $this->db->set('qtdade_vendida', ($row->qtdade_vendida+$row->qtdade));
                	}else{
	                    $this->db->set('qtdade_bloqueada', ($row->qtdade_bloqueada+$row->qtdade));
                	}
                    $this->db->set('qtdade_saldo', ($row->qtdade_saldo-$row->qtdade));
                    $this->db->where("id", $row->produto);
                    if($this->db->update("produto")){
						if($row->cupom){
		                    $this->db->set('utilizado', ($row->cupom_utilizado+$row->qtdade));
							$this->db->where("id", $row->cupomid);
							$this->db->update("cupom");
						}
	                    $this->db->where("produto", $row->produto);
	                    $this->db->where("usuario", $usuario[0]->id);
	                    $this->db->delete("carrinho");
                    }
					
                }
				if($status == '1'){
					
					if(($row->tipo == '4' || $row->tipo == '5') && empty($itempresente[0]->enviar)) {
						$tituloingresso = '<br/>Link para download:<br/><br/>';
						$ingressocorpo .= '<a href="'.base_url().'download/externo/'.$tokenitem.'">Baixar '.$row->produtonome.'</a><br/>';
					} elseif($row->tipo == '1') {
						$this->geraqrcod($row->qtdade, $pedidoitem, $row->id);
						$itemingressos = $this->itemingressos($pedidoitem);
						if(!empty($itemingressos)){
							
				         $tituloingresso = '<br/>Abaixo estão os links individuais dos tickets para download:<br/><br/>';
							foreach ($itemingressos as $key => $row3) {
	
								$ingressocorpo .= '<a href="'.base_url().'ticket/gerarIngresso/'.$row3->token.'">Ticket '.sprintf("%05d", $pedidoitem).'-'.sprintf("%02d", $row3->numero).'</a><br/>';
								
								if($row3->particid){
									if(!$tituloparticipantes){
										$tituloparticipantes .= "Abaixo está a lista de participantes:<br/><br/>";
									}
									$corpoparticipantes .= "<strong>Nome do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->particnome."<br/>";
									$corpoparticipantes .= "<strong>E-mail do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->particemail."<br/>";
									$corpoparticipantes .= "<strong>Telefone do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->partictelefone."<br/>";
									$corpoparticipantes .= "<strong>CPF do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->paticcpf."<br/><br/>";
									$ingressoPDF .= "<b>Nome do participante:</b> ".$row3->particnome."<br/>";
									if($row3->enviar){
								        $pedidocorpopaticipante = "
										Olá ".$row3->particnome.",<br/><br/>"
								        .$usuario[0]->nome." realizou uma inscrição no site da ".$configuracao[0]->nome_projeto." para o evento ".$row->eventotitulo." e colocou você como participante.<br/><br/>
								        Para saber tudo sobre o evento, por favor acesse <a href='".$this->session->userdata('url_projeto')."'>".$this->session->userdata('url_projeto')."</a>. Aproveitamos também para incentivá-lo(a) a acompanhar as nossas redes sociais.<br/><br/>
								        Abaixo encontra-se o link para o ingresso do evento, bem como observações e instruções, caso necessário.<br/><br/>";
								        $pedidocorpopaticipante .= $pedidoobscorpo;							
										$pedidocorpopaticipante .= '<a href="'.base_url().'ticket/gerarIngresso/'.$row3->token.'">Ingresso '.sprintf("%05d", $pedidoitem).'-'.sprintf("%02d", $row3->numero).'</a><br/><br/>';
										$pedidocorpopaticipante .= "Atenciosamente,<br/><br/>
										".$configuracao[0]->assinatura_nome."<br/>
										".$configuracao[0]->assinatura_link;
	
																	
										if($this->session->userdata('id')){
										    $this->load->library('email');
										    $config['mailtype'] = 'html';
										    $this->email->initialize($config);
										    	        
										    $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
										    $this->email->to($row3->particemail);
										    $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Participante do evento: ".$row->eventotitulo);
										    $this->email->message($pedidocorpopaticipante);
											$this->email->send();
										}
									}
								}
								
							}
						}
					}

					if(!empty($itempresente[0]->enviar)){
						$presentemes = date('m')+3;
						
						if($row->tipo == '4' || $row->tipo == '5'){
					        $presentecorpo .= "
							Olá ".$itempresente[0]->nome.",<br/><br/>"
					        .$this->session->userdata('nome')." 
					        realizou uma compra na loja ".$configuracao[0]->nome_projeto." e presenteou você com ".$row->produtonome.". 
					        Lhe desejamos uma incrível experiência! <br /><br />";

					        /*$presentecorpo .= "
					        Unidade: ".$row->undnome."<br/>
							Telefone: ".$row->undtelefone."<br/>
							Endereço: ".$row->undendereco."<br/><br/>";*/
							
					        $presentecorpo .= "Mensagem para você:<br/>".$itempresente[0]->mensagem."<br/><br/>";
	
							$presentecorpo .= 'Link para download:<br/><br/>';
							$presentecorpo .= '<a href="'.base_url().'download/externo/'.$tokenitem.'">Baixar '.$row->produtonome.'</a><br/><br/>';
	
					        $presentecorpo .= $tituloingresso;
							$presentecorpo .= $ingressocorpo;
							
	
							$presentecorpo .= "Atenciosamente,<br/><br/>
							".$configuracao[0]->assinatura_nome."<br/>
							".$configuracao[0]->assinatura_link;
						}else{
					        $presentecorpo .= "
							Olá ".$itempresente[0]->nome.",<br/><br/>"
					        .$this->session->userdata('nome')." 
					        realizou uma compra na loja ".$configuracao[0]->nome_projeto." e presenteou você com ".$row->produtonome.". 
					        Estamos lhe aguardando para uma incrível experiência! Você pode agendar este Gift Card até o dia 
					        ".date('d')."/".$presentemes."/".date('Y').". Agende agora mesmo seu horário pelo site ".$this->session->userdata('url_projeto')." ou 
					        pelo telefone abaixo!<br/><br/>";
					        /*$presentecorpo .= "
					        Unidade: ".$row->undnome."<br/>
							Telefone: ".$row->undtelefone."<br/>
							Endereço: ".$row->undendereco."<br/><br/>";*/
							
					        $presentecorpo .= "Mensagem para você:<br/>".$itempresente[0]->mensagem."<br/><br/>";
	
					        $presentecorpo .= $tituloingresso;
							$presentecorpo .= $ingressocorpo;
							
	
							$presentecorpo .= "<br/>* É indispensável a apresentação do Gift Card, por isso imprima ou guarde em seu celular o ticket/código.<br/><br/>";
							$presentecorpo .= "Atenciosamente,<br/><br/>
							".$configuracao[0]->assinatura_nome."<br/>
							".$configuracao[0]->assinatura_link;

						}

				        $this->load->library('email');
				        $config['mailtype'] = 'html';
				        $this->email->initialize($config);

						if($this->session->userdata('id')){
					        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
					        $this->email->to($itempresente[0]->email);
					        $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Um presente para você");
					        $this->email->message($presentecorpo);
							$this->email->send();
						}
					}
				}
            }

			$pedidomensagem .= $pedidotitulo;
			$pedidomensagem .= $pedidocorpo;
			$pedidomensagem .= $pedidoformulariocorpo;
			$pedidomensagem .= $pedidoobscorpo;
			$pedidomensagem .= $tituloparticipantes;
			$pedidomensagem .= $corpoparticipantes;
			$pedidomensagem .= $tituloingresso;
			$pedidomensagem .= $ingressocorpo;
			$pedidomensagem .= "<br/><br/>
			".$configuracao[0]->assinatura_nome."<br/>
			".$configuracao[0]->assinatura_link;
						
			if($usuario[0]->id){
		        $this->load->library('email');
		        $config['mailtype'] = 'html';
		        $this->email->initialize($config);
	            	        
		        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
		        $this->email->to($usuario[0]->email);
                if($status == '9'){
                    $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Aguardando pagamento");
                } else {
                    $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Confirmação de compra");
                }
		        $this->email->message($pedidomensagem);
				if($this->email->send()){
					
					if($fretecorpo){
						$pedidoadminmensagem .= $pedidoadmintitulo;
						$pedidoadminmensagem .= $pedidocorpo;
						$pedidoadminmensagem .= $tituloparticipantes;
						$pedidoadminmensagem .= $corpoparticipantes;
						$pedidoadminmensagem .= "<br/><br/>
						".$configuracao[0]->assinatura_nome."<br/>
						".$configuracao[0]->assinatura_link;
						
						
				        $this->load->library('email');
				        $config['mailtype'] = 'html';
				        $this->email->initialize($config);
			            	        
				        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
				        $this->email->to($emailto[0]->caminho);
				        $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Compra de produto com endereço de entrega");
				        $this->email->message($pedidoadminmensagem);
						$this->email->send();
					}
					
					$retorno = true;
				}
				$retorno = true;
			}
        
        }
        
        if($retorno && $configuracao[0]->emissao_nota && $pagamentoforma[0]->id != '99') {
    		$nf_pedido = $this->pedido('', $pedido);
    	
			$url = 'https://bling.com.br/Api/v2/notafiscal/json/';
			$xml = '<?xml version="1.0" encoding="UTF-8"?>
						<pedido>
							 <tipo>S</tipo>
							 <numero_loja>'.$nf_pedido[0]->id.'</numero_loja>';
							 if($item[0]->tiponota == '1'){
							 	$xml .= '<nat_operacao>Venda de mercadorias</nat_operacao>';
							 }else{
							 	$xml .= '<nat_operacao>Prestação de serviços</nat_operacao>';
							 }
							 $xml .= '<cliente>
						        <nome>'.$nf_pedido[0]->usuarionome.'</nome>
						        <tipoPessoa>'.$nf_pedido[0]->pessoa.'</tipoPessoa>
						        <cpf_cnpj>'.str_replace( "/" , "" ,str_replace("-" , "" ,str_replace("." , "" , $nf_pedido[0]->cpf))).'</cpf_cnpj>
						        <ie_rg>'.$nf_pedido[0]->ie.'</ie_rg>
						        <endereco>'.$nf_pedido[0]->endereco.'</endereco>
						        <numero>'.$nf_pedido[0]->numero.'</numero>
						        <bairro>'.$nf_pedido[0]->bairro.'</bairro>
						        <cep>'.$nf_pedido[0]->cep.'</cep>
						        <cidade>'.$nf_pedido[0]->cidade.'</cidade>
						        <uf>'.$nf_pedido[0]->uf.'</uf>
						        <fone>'.$nf_pedido[0]->telcel.'</fone>
						        <email>'.$nf_pedido[0]->email.'</email>
						    </cliente>
						    <itens>';
						    
						    foreach ($item as $row) {
						        $xml .= '
						        <item>
						            <codigo>'.$row->produto.'</codigo>
						            <descricao>'.$row->produtonome.'</descricao>
						            <un>un</un>
						            <qtde>'.$row->qtdade.'</qtde>
						            <vlr_unit>'.$row->valorunitario.'</vlr_unit>';
							 if($item[0]->tiponota == '1'){
							 	$xml .= '<tipo>P</tipo>';
							 	$xml .= '<class_fiscal>'.$row->ncm.'</class_fiscal>';
							 }else{
							 	$xml .= '<tipo>S</tipo>';
							 	$xml .= '<class_fiscal>0000.00.00</class_fiscal>';
							 	$xml .= '<cod_servico>8.02</cod_servico>';
							 }

						     $xml .= '<origem>0</origem>
						        </item>';
						    }						        
						    $xml .= '
						    </itens>
						</pedido>';
						//echo $xml;
						//exit;
			$posts = array (
			    "apikey" => $configuracao[0]->bling_apikey,
			    "xml" => rawurlencode($xml)
			);
			$nf_retorno = json_decode($this->executeSendFiscalDocument($url, $posts), true);
			
			//echo $nf_retorno['retorno']['notasfiscais'][0]['notaFiscal']['numero'];
			//echo $configuracao[0]->bling_apikey;
			
			if(!empty($nf_retorno['retorno']['notasfiscais'][0]['notaFiscal']['numero'])) {
				$url = 'https://bling.com.br/Api/v2/notafiscal/json/';
				$posts = array (
				    "apikey"    => $configuracao[0]->bling_apikey,
				    "number"    => $nf_retorno['retorno']['notasfiscais'][0]['notaFiscal']['numero'],
				    "serie"     => "1",
					 "sendEmail" => "true"
				);
				$nf_envio = $this->executeSendFiscalDocument($url, $posts);
			}
        		
        }
        
		//echo $retorno;
        return $retorno;

    }

    public function pixautoriza($status, $pedido){
    	//echo ($forma_pagamento);
    	
		$this->load->library('cidompdf');
        	
        $retorno = false;
        $tid = $tid."";
        $emailto = $this->emailto();
        $emailfrom = $this->emailfrom();
        $configuracao = $this->configuracao();
	    
		$mes_ext[1] = "Janeiro";
		$mes_ext[2] = "Fevereiro";
		$mes_ext[3] = "Março";
		$mes_ext[4] = "Abril";
		$mes_ext[5] = "Maio";
		$mes_ext[6] = "Junho";
		$mes_ext[7] = "Julho";
		$mes_ext[8] = "Agosto";
		$mes_ext[9] = "Setembro";
		$mes_ext[10] = "Outubro";
		$mes_ext[11] = "Novembro";
		$mes_ext[12] = "Dezembro";

        $this->db->set('status', $status);
        $this->db->where('id', $pedido[0]->id);
        if($this->db->update('pedido')){

			$pedidoadmintitulo = "";
			$pedidotitulo = "";
			$tituloingresso = "";
			$pedidoformulariocorpo = "";
			$tituloparticipantes = "";
			$pedidocorpo = "";
			$presentecorpo = "";
			$fretecorpo = "";
			$pedidoobscorpo = "";
			$ingressocorpo = "";
			$corpoparticipantes = "";
			$pedidomensagem = "";
			$pedidoadminmensagem = "";

			$itemfrete = $this->pedidofrete($pedido[0]->id);
			
			if($itemfrete[0]->id){
                $pedidoadmintitulo .= "
                Data da compra: ".date("d")." de ".$mes_ext[date("n")]." de ".date("Y")." às ".date("H:i")."<br/>
                Assunto: [Site ".$configuracao[0]->nome_projeto."] Compra de produto com endereço de entrega<br/><br/>
                
                ---------- Mensagem ----------<br/><br/>
                Seguem abaixo os dados da compra no site ".$configuracao[0]->nome_projeto.":<br/><br/>
                ";
                $fretecorpo .= "
                Abaixo seguem os dados de entrega: <br/><br/>
                <strong>Endereço:</strong> ".$itemfrete[0]->endereco."<br/>
                <strong>Bairro:</strong> ".$itemfrete[0]->bairro."<br/>
                <strong>Cidade/UF:</strong> ".$itemfrete[0]->cidade."/".$itemfrete[0]->uf."<br/>
                <strong>CEP:</strong> ".$itemfrete[0]->cep."<br/><br/>";
			}

			$pedidostatus = $this->status($status);

	        $pedidotitulo .= "Olá ".$this->session->userdata('nome').",<br/><br/>
	        Seguem abaixo os dados da sua compra no site ".$configuracao[0]->nome_projeto.":<br/><br/>";
			
	        $pedidocorpo .= "
	        <strong>Forma de pagamento:</strong> ".$pedido[0]->pagamentoforma."<br/>
	        <strong>Nome do comprador:</strong> ".$this->session->userdata('nome')."<br/>";
			
	       	if($pagamentoTotal[0]->totalfrete > 0){
		        $pedidocorpo .= "<strong>Valor total dos produtos:</strong> R$ ".number_format($pedido[0]->valor, 2, ',', '.')."<br/>
		        <strong>Taxa de entrega:</strong> R$ ".number_format($pedido[0]->frete, 2, ',', '.')."<br/>";
	       	}
			
	        $pedidocorpo .= "<strong>Valor total da compra:</strong> R$ ".number_format($pedido[0]->valorpago, 2, ',', '.')."<br/>
	        <strong>Status da compra:</strong> ".$pedidostatus[0]->nome."<br/><br/>
	        $fretecorpo
	        Lista dos itens comprados:<br/><br/>";
	        
	         $item = $this->pedidoitem($pedido[0]->id);
			
            foreach ($item as $row) {

                if($row->cursoid && $row->cursotipo == '1'){
                    
                    $usunome = explode(" ", $this->session->userdata('nome'));
                    $cursoid = md5($row->cursoid);
                
                    $corpocurso = "
                	Prezado(a) ".$usunome[0].",<br/><br/>
                	
                	Para acessar o curso ".$row->cursonome." clique no link a seguir ou copie a url na barra de endereços do seu navegador: 
                	
                	".base_url("login/pagina")."<br/><br/>
                	
                	".$configuracao[0]->assinatura_nome."<br/>
                	".$configuracao[0]->assinatura_link;
                
                	if($this->session->userdata('id')){
                        $this->load->library('email');
                        $config['mailtype'] = 'html';
                        $this->email->initialize($config);
                        	        
                        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
                        $this->email->to($this->session->userdata('email'));
                
                        $this->email->subject("Acesso ao curso ".$row->cursonome." do site ".$configuracao[0]->nome_projeto);
                        $this->email->message($corpocurso);	
                
                        $this->email->send();
                	}
                
                }
				
                $pedidocorpo .= "
                <table style='width:100%;'>
                <tr>
                <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Descrição</b></td>
                <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Preço</b></td>
                <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Quantidade</b></td>
                <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Total</b></td>
                </tr>";                
                $pedidocorpo .= '<tr>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= $row->produtonome;
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= 'R$ '.str_replace(".", ",", $row->preco);
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= $row->qtdade;
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= 'R$ '.str_replace(".", ",", $row->valor);
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '</tr>';
	            $pedidocorpo .= '</table><br/>';
				
				if($row->obs){
		            $pedidoobscorpo .= '<br/><strong>Observações adicionais e instruções: </strong><br/>'.$row->obs;
				}
				
                $pedidoitem = $row->id;
                
                $itemformulario = $this->pedidoitemformulario($row->id);
                
                if(!empty($itemformulario)){
                	$pedidoformulariocorpo .= "<br/>Dados complementares da compra:<br/><br/>";					
                	foreach ($itemformulario as $key => $rowform) {
                        $pedidoformulariocorpo .= "<b>".$rowform->label.":</b> ".$rowform->descricao."<br/>";
                	}
                	$pedidoformulariocorpo .= "<br/>";
                }
                
                $itempresente = $this->pedidoitempresente($row->id);
                
                if(!empty($itempresente)){
                    
					if($status == '1'){
						
						if(!$itempresente[0]->nascimento || $itempresente[0]->nascimento == "0000-00-00"){
							$nascimento = "Data de nascimento não preenchida";
						}else{
							$nascimento = date("d/m/Y", strtotime($itempresente[0]->nascimento));
						}
						if($itempresente[0]->cpf){
							$cpf = $itempresente[0]->cpf;
						}else{
							$cpf = "CPF não preenchido";
						}
						$pedidoobscorpo .= "<br/>Abaixo seguem os dados da pessoa que receberá este produto como presente:<br/><br/>
											<b>Nome:</b> ".$itempresente[0]->nome."<br/>
											<b>Data de nascimento:</b> ".$nascimento."<br/>
											<b>E-mail:</b> ".$itempresente[0]->email."<br/>
											<b>Telefone:</b> ".$itempresente[0]->telefone."<br/>
											<b>CPF:</b> ".$cpf."<br/>";
					}
				}
				
            	if($status == '1'){
                    $this->db->set('qtdade_vendida', ($row->qtdade_vendida+$row->qtdade));
            	}else{
                    $this->db->set('qtdade_bloqueada', ($row->qtdade_bloqueada+$row->qtdade));
            	}
                $this->db->set('qtdade_saldo', ($row->qtdade_saldo-$row->qtdade));
                $this->db->where("id", $row->produto);
                if($this->db->update("produto")){
					if($row->cupom){
	                    $this->db->set('utilizado', ($row->cupom_utilizado+$row->qtdade));
						$this->db->where("id", $row->cupomid);
						$this->db->update("cupom");
					}
                }
					
				if($status == '1'){
					
					if(($row->tipo == '4' || $row->tipo == '5') && empty($itempresente[0]->enviar)) {
						$tituloingresso = '<br/>Link para download:<br/><br/>';
						$ingressocorpo .= '<a href="'.base_url().'download/externo/'.$tokenitem.'">Baixar '.$row->produtonome.'</a><br/>';
					} elseif($row->tipo == '1') {
						$this->geraqrcod($row->qtdade, $pedidoitem, $row->id);
						$itemingressos = $this->itemingressos($pedidoitem);
						if(!empty($itemingressos)){
							
				         $tituloingresso = '<br/>Abaixo estão os links individuais dos tickets para download:<br/><br/>';
							foreach ($itemingressos as $key => $row3) {
	
								$ingressocorpo .= '<a href="'.base_url().'ticket/gerarIngresso/'.$row3->token.'">Ticket '.sprintf("%05d", $pedidoitem).'-'.sprintf("%02d", $row3->numero).'</a><br/>';
								
								if($row3->particid){
									if(!$tituloparticipantes){
										$tituloparticipantes .= "Abaixo está a lista de participantes:<br/><br/>";
									}
									$corpoparticipantes .= "<strong>Nome do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->particnome."<br/>";
									$corpoparticipantes .= "<strong>E-mail do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->particemail."<br/>";
									$corpoparticipantes .= "<strong>Telefone do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->partictelefone."<br/>";
									$corpoparticipantes .= "<strong>CPF do paticipante ".sprintf("%02d", $row3->numero).":</strong> ".$row3->paticcpf."<br/><br/>";
									$ingressoPDF .= "<b>Nome do participante:</b> ".$row3->particnome."<br/>";
									if($row3->enviar){
								        $pedidocorpopaticipante = "
										Olá ".$row3->particnome.",<br/><br/>"
								        .$this->session->userdata('nome')." realizou uma inscrição no site da ".$configuracao[0]->nome_projeto." para o evento ".$row->eventotitulo." e colocou você como participante.<br/><br/>
								        Para saber tudo sobre o evento, por favor acesse <a href='".$this->session->userdata('url_projeto')."'>".$this->session->userdata('url_projeto')."</a>. Aproveitamos também para incentivá-lo(a) a acompanhar as nossas redes sociais.<br/><br/>
								        Abaixo encontra-se o link para o ingresso do evento, bem como observações e instruções, caso necessário.<br/><br/>";
								        $pedidocorpopaticipante .= $pedidoobscorpo;							
										$pedidocorpopaticipante .= '<a href="'.base_url().'ticket/gerarIngresso/'.$row3->token.'">Ingresso '.sprintf("%05d", $pedidoitem).'-'.sprintf("%02d", $row3->numero).'</a><br/><br/>';
										$pedidocorpopaticipante .= "Atenciosamente,<br/><br/>
										".$configuracao[0]->assinatura_nome."<br/>
										".$configuracao[0]->assinatura_link;
	
																	
										if($this->session->userdata('id')){
										    $this->load->library('email');
										    $config['mailtype'] = 'html';
										    $this->email->initialize($config);
										    	        
										    $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
										    $this->email->to($row3->particemail);
										    $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Participante do evento: ".$row->eventotitulo);
										    $this->email->message($pedidocorpopaticipante);
											$this->email->send();
										}
									}
								}
								
							}
						}
					}

					if(!empty($itempresente[0]->enviar)){
						$presentemes = date('m')+3;
						
						if($row->tipo == '4' || $row->tipo == '5'){
					        $presentecorpo .= "
							Olá ".$itempresente[0]->nome.",<br/><br/>"
					        .$this->session->userdata('nome')." 
					        realizou uma compra na loja ".$configuracao[0]->nome_projeto." e presenteou você com ".$row->produtonome.". 
					        Lhe desejamos uma incrível experiência! <br /><br />";

					        /*$presentecorpo .= "
					        Unidade: ".$row->undnome."<br/>
							Telefone: ".$row->undtelefone."<br/>
							Endereço: ".$row->undendereco."<br/><br/>";*/
							
					        $presentecorpo .= "Mensagem para você:<br/>".$itempresente[0]->mensagem."<br/><br/>";
	
							$presentecorpo .= 'Link para download:<br/><br/>';
							$presentecorpo .= '<a href="'.base_url().'download/externo/'.$tokenitem.'">Baixar '.$row->produtonome.'</a><br/><br/>';
	
					        $presentecorpo .= $tituloingresso;
							$presentecorpo .= $ingressocorpo;
							
	
							$presentecorpo .= "Atenciosamente,<br/><br/>
							".$configuracao[0]->assinatura_nome."<br/>
							".$configuracao[0]->assinatura_link;
						}else{
					        $presentecorpo .= "
							Olá ".$itempresente[0]->nome.",<br/><br/>"
					        .$this->session->userdata('nome')." 
					        realizou uma compra na loja ".$configuracao[0]->nome_projeto." e presenteou você com ".$row->produtonome.". 
					        Estamos lhe aguardando para uma incrível experiência! Você pode agendar este Gift Card até o dia 
					        ".date('d')."/".$presentemes."/".date('Y').". Agende agora mesmo seu horário pelo site ".$this->session->userdata('url_projeto')." ou 
					        pelo telefone abaixo!<br/><br/>";
					        /*$presentecorpo .= "
					        Unidade: ".$row->undnome."<br/>
							Telefone: ".$row->undtelefone."<br/>
							Endereço: ".$row->undendereco."<br/><br/>";*/
							
					        $presentecorpo .= "Mensagem para você:<br/>".$itempresente[0]->mensagem."<br/><br/>";
	
					        $presentecorpo .= $tituloingresso;
							$presentecorpo .= $ingressocorpo;
							
	
							$presentecorpo .= "<br/>* É indispensável a apresentação do Gift Card, por isso imprima ou guarde em seu celular o ticket/código.<br/><br/>";
							$presentecorpo .= "Atenciosamente,<br/><br/>
							".$configuracao[0]->assinatura_nome."<br/>
							".$configuracao[0]->assinatura_link;

						}

				        $this->load->library('email');
				        $config['mailtype'] = 'html';
				        $this->email->initialize($config);

						if($this->session->userdata('id')){
					        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
					        $this->email->to($itempresente[0]->email);
					        $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Um presente para você");
					        $this->email->message($presentecorpo);
							$this->email->send();
						}
					}
				}
            }

			$pedidomensagem .= $pedidotitulo;
			$pedidomensagem .= $pedidocorpo;
			$pedidomensagem .= $pedidoformulariocorpo;
			$pedidomensagem .= $pedidoobscorpo;
			$pedidomensagem .= $tituloparticipantes;
			$pedidomensagem .= $corpoparticipantes;
			$pedidomensagem .= $tituloingresso;
			$pedidomensagem .= $ingressocorpo;
			$pedidomensagem .= "<br/><br/>
			".$configuracao[0]->assinatura_nome."<br/>
			".$configuracao[0]->assinatura_link;
						
			if($this->session->userdata('id')){
		        $this->load->library('email');
		        $config['mailtype'] = 'html';
		        $this->email->initialize($config);
	            	        
		        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
		        $this->email->to($this->session->userdata('email'));
		        $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Confirmação de compra");
		        $this->email->message($pedidomensagem);
		        
				if($this->email->send()){
					if($fretecorpo){
						$pedidoadminmensagem .= $pedidoadmintitulo;
						$pedidoadminmensagem .= $pedidocorpo;
						$pedidoadminmensagem .= $tituloparticipantes;
						$pedidoadminmensagem .= $corpoparticipantes;
						$pedidoadminmensagem .= "<br/><br/>
						".$configuracao[0]->assinatura_nome."<br/>
						".$configuracao[0]->assinatura_link;
						
						
				        $this->load->library('email');
				        $config['mailtype'] = 'html';
				        $this->email->initialize($config);
			            	        
				        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
				        $this->email->to($emailto[0]->caminho);
				        $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Compra de produto com endereço de entrega");
				        $this->email->message($pedidoadminmensagem);
						$this->email->send();
					}
					$retorno = true;
				}
				$retorno = true;
			}
        
        }
        
        if($retorno && $configuracao[0]->emissao_nota && $pagamentoforma[0]->id != '99') {
    		$nf_pedido = $this->pedido('', $pedido);
    	
			$url = 'https://bling.com.br/Api/v2/notafiscal/json/';
			$xml = '<?xml version="1.0" encoding="UTF-8"?>
						<pedido>
							 <tipo>S</tipo>
							 <numero_loja>'.$nf_pedido[0]->id.'</numero_loja>';
							 if($item[0]->tiponota == '1'){
							 	$xml .= '<nat_operacao>Venda de mercadorias</nat_operacao>';
							 }else{
							 	$xml .= '<nat_operacao>Prestação de serviços</nat_operacao>';
							 }
							 $xml .= '<cliente>
						        <nome>'.$nf_pedido[0]->usuarionome.'</nome>
						        <tipoPessoa>'.$nf_pedido[0]->pessoa.'</tipoPessoa>
						        <cpf_cnpj>'.str_replace( "/" , "" ,str_replace("-" , "" ,str_replace("." , "" , $nf_pedido[0]->cpf))).'</cpf_cnpj>
						        <ie_rg>'.$nf_pedido[0]->ie.'</ie_rg>
						        <endereco>'.$nf_pedido[0]->endereco.'</endereco>
						        <numero>'.$nf_pedido[0]->numero.'</numero>
						        <bairro>'.$nf_pedido[0]->bairro.'</bairro>
						        <cep>'.$nf_pedido[0]->cep.'</cep>
						        <cidade>'.$nf_pedido[0]->cidade.'</cidade>
						        <uf>'.$nf_pedido[0]->uf.'</uf>
						        <fone>'.$nf_pedido[0]->telcel.'</fone>
						        <email>'.$nf_pedido[0]->email.'</email>
						    </cliente>
						    <itens>';
						    
						    foreach ($item as $row) {
						        $xml .= '
						        <item>
						            <codigo>'.$row->produto.'</codigo>
						            <descricao>'.$row->produtonome.'</descricao>
						            <un>un</un>
						            <qtde>'.$row->qtdade.'</qtde>
						            <vlr_unit>'.$row->valorunitario.'</vlr_unit>';
							 if($item[0]->tiponota == '1'){
							 	$xml .= '<tipo>P</tipo>';
							 	$xml .= '<class_fiscal>'.$row->ncm.'</class_fiscal>';
							 }else{
							 	$xml .= '<tipo>S</tipo>';
							 	$xml .= '<class_fiscal>0000.00.00</class_fiscal>';
							 	$xml .= '<cod_servico>8.02</cod_servico>';
							 }

						     $xml .= '<origem>0</origem>
						        </item>';
						    }						        
						    $xml .= '
						    </itens>
						</pedido>';
						//echo $xml;
						//exit;
			$posts = array (
			    "apikey" => $configuracao[0]->bling_apikey,
			    "xml" => rawurlencode($xml)
			);
			$nf_retorno = json_decode($this->executeSendFiscalDocument($url, $posts), true);
			
			//echo $nf_retorno['retorno']['notasfiscais'][0]['notaFiscal']['numero'];
			//echo $configuracao[0]->bling_apikey;
			
			if(!empty($nf_retorno['retorno']['notasfiscais'][0]['notaFiscal']['numero'])) {
				$url = 'https://bling.com.br/Api/v2/notafiscal/json/';
				$posts = array (
				    "apikey"    => $configuracao[0]->bling_apikey,
				    "number"    => $nf_retorno['retorno']['notasfiscais'][0]['notaFiscal']['numero'],
				    "serie"     => "1",
					 "sendEmail" => "true"
				);
				$nf_envio = $this->executeSendFiscalDocument($url, $posts);
			}
        		
        }
        

		//echo $retorno;
        return $retorno;

    }

	function executeSendFiscalDocument($url, $data){
	    $curl_handle = curl_init();
	    curl_setopt($curl_handle, CURLOPT_URL, $url);
	    curl_setopt($curl_handle, CURLOPT_POST, count($data));
	    curl_setopt($curl_handle, CURLOPT_POSTFIELDS, $data);
	    curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, TRUE);
	    $response = curl_exec($curl_handle);
	    curl_close($curl_handle);
	    return $response;
	}

    public function altPedidoPagseguro($tid, $status){
    	//exit($forma_pagamento);
		$this->load->library('cidompdf');
        	
	    $retorno = false;
        $tid = $tid."";
	    $emailfrom = $this->emailfrom();
	    $configuracao = $this->configuracao();
		        
		$mes_ext[1] = "Janeiro";
		$mes_ext[2] = "Fevereiro";
		$mes_ext[3] = "Março";
		$mes_ext[4] = "Abril";
		$mes_ext[5] = "Maio";
		$mes_ext[6] = "Junho";
		$mes_ext[7] = "Julho";
		$mes_ext[8] = "Agosto";
		$mes_ext[9] = "Setembro";
		$mes_ext[10] = "Outubro";
		$mes_ext[11] = "Novembro";
		$mes_ext[12] = "Dezembro";
		
        $this->db->set('status', $status);
        $this->db->where('tid', $tid);
        if($this->db->update('pedido')){
        	
            $pedido = $this->pedido($tid);
            
			$pagamentoTotal = $this->pagamentoTotal($this->session->userdata('id'));
						
	        $pedidocorpo = "
			Olá ".$this->session->userdata('nome').",<br/><br/>
	        Seguem abaixo os dados da sua compra no site ".$configuracao[0]->nome_projeto.":<br/><br/>
	        <strong>Forma de pagamento:</strong> ".$pedido[0]->pagamentoforma."<br/>
	        <strong>Nome do comprador:</strong> ".$pedido[0]->usuarionome."<br/>";
			
	       	if($pagamentoTotal[0]->totalfrete > 0){
		        $pedidocorpo .= "<strong>Valor total dos produtos:</strong> R$ ".$pagamentoTotal[0]->total."<br/>
		        <strong>Taxa de entrega:</strong> R$ ".$pagamentoTotal[0]->totalfrete."<br/>";
	       	}
			
	        $pedidocorpo .= "
	        <strong>Valor total da compra:</strong> R$ ".number_format($pedido[0]->valor, 2, ',', '.')."<br/>
	        <strong>Status da compra:</strong> ".$pedido[0]->statusnome."<br/><br/>
	        Lista dos itens comprados:<br/><br/>";
			
            foreach ($this->pedidoitem($pedido[0]->id) as $row) {
				
				if($row->cursoid && $row->cursotipo == '1'){
		            
		            $usunome = explode(" ", $this->session->userdata('nome'));
		            $cursoid = md5($row->cursoid);
		        
		            $corpocurso = "
					Prezado(a) ".$usunome[0].",<br/><br/>
					
					Para acessar o curso ".$row->cursonome." clique no link a seguir ou copie a url na barra de endereços do seu navegador: 
					
					".base_url("login/curso/".$cursoid)."<br/><br/>
					
					".$configuracao[0]->assinatura_nome."<br/>
					".$configuracao[0]->assinatura_link;
		
			        $this->load->library('email');
			        $config['mailtype'] = 'html';
			        $this->email->initialize($config);
		            	        
			        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
			        $this->email->to($pedido[0]->email);
		
		            $this->email->subject("Acesso ao curso ".$row->cursonome." do site ".$configuracao[0]->nome_projeto);
		            $this->email->message($corpocurso);	
		
		            $this->email->send();
					
				}
				
				$pedidocorpo .= "
	            <table style='width:100%;'>
	            <tr>
	            <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Descrição</b></td>
	            <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Preço</b></td>
	            <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Quantidade</b></td>
	            <td style='width:24%;text-align:left;margin-bottom:20px;'><b>Total</b></td>
	            </tr>";                
                $pedidocorpo .= '<tr>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= $row->produtonome;
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= 'R$ '.str_replace(".", ",", $row->preco);
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= $row->qtdade;
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '<td>';
                $pedidocorpo .= 'R$ '.str_replace(".", ",", $row->valor);
                $pedidocorpo .= '</td>';
                $pedidocorpo .= '</tr>';
	            $pedidocorpo .= '</table><br/>';
				
				if($row->obs){
		            $pedidocorpo .= '<br/><strong>Observações adicionais e instruções: </strong><br/>'.$row->obs;
				}

				if($status == '1'){
	                $this->db->set('qtdade_vendida', ($row->qtdade_vendida+$row->qtdade));
	                $this->db->set('qtdade_bloqueada', ($row->qtdade_bloqueada-$row->qtdade));
	                $this->db->where("id", $row->produto);
	                $this->db->update("produto");
				}else{
	                $this->db->set('qtdade_bloqueada', ($row->qtdade_bloqueada-$row->qtdade));
					$this->db->set('qtdade_saldo', ($row->qtdade_saldo+$row->qtdade));
	                $this->db->where("id", $row->produto);
	                $this->db->update("produto");
				}
				
				if($status == '1'){

					$this->geraqrcod($row->qtdade, $row->id);

					$itemingressos = $this->itemingressos($row->id);
					if(!empty($itemingressos)){
			            $pedidocorpo .= '<br/>Abaixo estão os links individuais dos ingressos para download:<br/><br/>';
						foreach ($itemingressos as $key => $row3) {

							$pedidocorpo .= '<a href="'.base_url().'iportal/public/biblioteca-de-arquivos/ticket/'.$row3->token.'.pdf">Ticket '.sprintf("%05d", $row->id).'-'.sprintf("%02d", $row3->numero).'<br/></a>';
							
							if($row3->particid){
						        $pedidocorpopaticipante = "
								Olá ".$row3->particnome.",<br/><br/>"
						        .$this->session->userdata('nome')." incluiu você como participante do evento: ".$row->eventotitulo.".
						        Abaixo está o link individual do ingresso para download:<br/><br/>";							
								$pedidocorpopaticipante .= '<a href="'.base_url().'iportal/public/biblioteca-de-arquivos/ticket/'.$row3->token.'.pdf">Ingresso '.sprintf("%05d", $pedidoitem).'-'.sprintf("%02d", $row3->numero).'</a><br/><br/>';
	
						$pedidocorpopaticipante .= $configuracao[0]->assinatura_nome."<br/>
						".$configuracao[0]->assinatura_link;	
						
							    $this->load->library('email');
							    $config['mailtype'] = 'html';
							    $this->email->initialize($config);
							    	        
							    $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
							    $this->email->to($row3->particemail);
							    $this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Participante do evento: ".$row->eventotitulo);
							    $this->email->message($pedidocorpopaticipante);
								if($this->email->send()){
									echo "Corpo: ".$pedidocorpopaticipante."<br/>Assunto: [Site ".$configuracao[0]->nome_projeto."] Participante do evento: ".$row->eventotitulo."<br/>To: ".$row3->particemail."<br/>From: ".$emailfrom[0]->caminho;
								}
								
							}
							
						}
					}
				}
            }

	        $this->load->library('email');
	        $config['mailtype'] = 'html';
	        $this->email->initialize($config);
            	        
	        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
	        $this->email->to($pedido[0]->email);
	        if($status == '1'){
	        	$this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Autorização de pagamento pela administradora");
	        }else{
	        	$this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Pagamento não autorizado pela administradora");
	        }
	        $this->email->message($pedidocorpo);
			if($this->email->send()){						
					
		        $this->load->library('email');
		        $config['mailtype'] = 'html';
		        $this->email->initialize($config);
	            	        
		        $this->email->from($emailfrom[0]->caminho, $configuracao[0]->nome_projeto);
		        $this->email->to($pedido[0]->email);
		        if($status == '1'){
		        	$this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Autorização de pagamento pela administradora");
		        }else{
		        	$this->email->subject("[Site ".$configuracao[0]->nome_projeto."] Pagamento não autorizado pela administradora");
		        }
		        $this->email->message($pedidocorpo);
				$this->email->send();
				
			}

            $retorno = true;
        }
        return $retorno;
    }

    function insereTid($tid, $usuario='', $carrinho=''){
    	$retorno = false;
		$tid = "".$tid;
    	if($carrinho){
    		$sqlwhere = "id = '$carrinho'";
    	}else{
    		$sqlwhere = "usuario = '$usuario'";
    	}
		$sql = "update carrinho set tid = '$tid' where $sqlwhere";
		$this->db->query($sql);
        if($this->db->affected_rows()){
        	$retorno = true;
        }
		return $retorno;
    }
	
	function geraqrcod($qtdade, $pedidoitem, $itemcarrinho=''){
		for ($i = 1; $i <= $qtdade; $i++) {
			$token = md5($pedidoitem.$i.time());
            $this->db->set('pedidoitem', $pedidoitem);
			$this->db->set('numero', $i);
			$this->db->set('token', $token);
			if ($this->db->insert('pedidoitem_ingresso')){
				$itemigresso = $this->db->insert_id();
				$itempaticipante = $this->itempaticipante($itemcarrinho, $i);
				if(!empty($itempaticipante)){
					$this->db->set('pedidoitem_ingresso', $itemigresso);
					$this->db->set('nome', $itempaticipante[0]->nome);
					$this->db->set('nascimento', $itempaticipante[0]->nascimento);
					$this->db->set('email', $itempaticipante[0]->email);
					$this->db->set('telefone', $itempaticipante[0]->telefone);
					$this->db->set('cpf', $itempaticipante[0]->cpf);
					$this->db->set('enviar', $itempaticipante[0]->enviar);
					if($this->db->insert('pedidoitem_participante')){
						$this->db->where('id', $itempaticipante[0]->id);
						$this->db->delete('carrinho_participante');
					}
				}
	            $this->load->library('ciqrcode');
                $params['data'] = base_url()."ticket/comprovante/".$token;
                $params['level'] = 'H';
                $params['size'] = 5;
                $params['savename'] = FCPATH.'iportal/public/biblioteca-de-arquivos/qrcode/'.$token.'.png';
                $this->ciqrcode->generate($params);
			}
		}	
	}
}
