<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Painel extends MX_Controller {

    function __construct() {
        parent::__construct();
    }

    function index(){
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        $data['meuscursos'] = $this->modelo->meuscursos();
        $data['titulo'] = 'Painel';
        $data['menu'] = '1';
        $this->load->view('meuscursosview', $data);
    }

    function meuscursos($tipo){
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        $data['tipoid'] = '';
        $data['titulo'] = '';
        if($tipo === 'on-line'){
            $data['tipoid'] = '1';
            $data['titulo'] = 'Cursos on-line';
        } elseif($tipo === 'aovivo'){
            $data['tipoid'] = '3';
            $data['titulo'] = 'Ao vivo';
        } elseif($tipo === 'presencial'){
            $data['tipoid'] = '2';
            $data['titulo'] = 'Cursos presenciais';
        }
        $data['meuscursos'] = $this->modelo->meuscursos($data['tipoid']);
        $menu = $data['tipoid'] == '1' ? '2' : ($data['tipoid'] == '2' ? '3' : '4');
        $data['menu'] = $menu;
        $this->load->view('meuscursosview', $data);
    }

    function curso($url_amigavel){
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        $data['curso'] = $this->modelo->curso($url_amigavel);
        $data['cursopercentual'] = $this->modelo->cursopercentual($data['curso'][0]->id);
		$data['modulos'] = $this->modelo->modulos($data['curso'][0]->id);
        $this->load->view('cursoview', $data);
    }

    function videoaula($videoaula){
			$this->my_acesso->logged();
			$this->load->model('painelmodel', 'modelo');
			$data['videoaula'] = $this->modelo->videoaula($videoaula);
			$data['chat'] = $this->modelo->chat($videoaula);
			$data['download'] = $this->modelo->download($videoaula);
			$data['videoaulalista'] = $this->modelo->videoaulalista($data['videoaula'][0]->moduloid);
			$data['modulos'] = $this->modelo->modulos($data['videoaula'][0]->cursoid);
			$this->load->view('videoaulaview', $data);
    }

    function buscavideo(){
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        $retorno['video'] = $this->modelo->videoaula($this->input->post('video'));
        if(stristr($retorno['video'][0]->video, 'youtube')) {
            $codigo_video = explode("/", $retorno['video'][0]->video);
            $retorno['codigo_video'] = $codigo_video[4];
            $retorno['imagem_video'] = '<div class="player__image" style="--player-image: url(https://img.youtube.com/vi/'.$retorno['codigo_video'].'/maxresdefault.jpg);"></div>';
            $retorno['html'] = '<iframe class="embed-responsive-item" id="player" frameborder="0" allowfullscreen="1" allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture" title="YouTube video player" src="'.$retorno['video'][0]->video.'?rel=0&amp;modestbranding=1&amp;autohide=1&amp;showinfo=0&amp;controls=1&amp;enablejsapi=1&amp;origin=https%3A%2F%2Fmedplay.tv&amp;widgetid=1"></iframe>';
        } elseif(stristr($retorno['video'][0]->video, 'vimeo')) {
            $codigo_video = explode("/", $retorno['video'][0]->video);
            $retorno['codigo_video'] = $codigo_video[4];
            $retorno['imagem_video'] = '<div class="player__image" style="--player-image: url(https://i.vimeocdn.com/video/'.$retorno['codigo_video'].'.webp)"></div>';
            $retorno['html'] = '<iframe class="embed-responsive-item" id="player" src="'.$retorno['video'][0]->video.'" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>';
        }
        echo json_encode($retorno);
    }

    function marcarpresenca(){
        $retorno = false;
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        if($this->modelo->marcarpresenca()){
            $retorno = true;
        }
        //echo $retorno." - ".$this->input->post('video')." - ".$this->session->userdata('id')." - ".date('Y-m-d H:i:s');
    }

    function meuspedidos(){
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        $pedidoPixPendente = $this->modelo->pedidoPixPendente();
        foreach($pedidoPixPendente as $row){
            $this->pixautoriza($row->tid);
        }
        $data['meuspedidos'] = $this->modelo->meuspedidos();
        $this->load->view('meuspedidosview', $data);
    }

    function adicionarchat(){
        $this->my_acesso->logged();
        $this->load->model('painelmodel', 'modelo');
        $this->modelo->adicionarchat();
    }

    function pixautoriza($tid){
        $this->load->library('my_pix');
        $this->load->model('pagamento/pagamentomodel');
		$pedido = $this->pagamentomodel->pedido($tid);
		$this->my_configuracao->confSess();
        $retorno['mensagem'] = "";
        $retorno['resultado'] = false;
        
        $configuracao = $this->pagamentomodel->configuracao();

		if($configuracao[0]->pagamento_producao){
            
            $url = $configuracao[0]->pix_url;
            $client_id = $configuracao[0]->pix_client_id; //Cliente ID do Pix em produção.
            $client_secret = $configuracao[0]->pix_client_secret; //Cliente secret do Pix em produção.
            if(stristr(__FILE__, 'desenvolvimento')) {
                $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado;
            } else {
                $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/iportal/public/biblioteca-de-arquivos/unidade/'.$configuracao[0]->pix_certificado; //Certificado do Pix em produção.
            }
			
		}else{
			
            //Ambiente de homologação
            $url = 'https://api-pix-h.gerencianet.com.br';
            $client_id = 'Client_Id_8ef12d5c598ca7e93c171e4be338cd7e2035fb13'; //Cliente ID do Pix em produção.
            $client_secret = 'Client_Secret_5f94e449d3fe4d219554477437c16514e86e3678'; //Cliente secret do Pix em produção.
            if(stristr(__FILE__, 'desenvolvimento')) {
                $certificado = $_SERVER['DOCUMENT_ROOT'].'/desenvolvimento/site/application/libraries/pix/files/certificates/certificadopix.pem';
            } else {
                $certificado = $_SERVER['DOCUMENT_ROOT'].'/site/application/libraries/pix/files/certificates/certificadopix.pem'; //Certificado do Pix em produção.
            }
        	                
		}

		$pix = $this->my_pix->consult_pix($url, $client_id, $client_secret, $certificado, $pedido[0]->tid);
		
		if(!empty($pix)){
            if(($pix['status'] == 'CONCLUIDA' && $pix['valor']['original'] == $pix['pix'][0]['valor'])){
                $pixautoriza = $this->pagamentomodel->pixautoriza('1', $pedido);
            }else{
                $pixautoriza = $this->pagamentomodel->pixautoriza('11', $pedido);
            }
		}
		

    }

}

