<!DOCTYPE html>
<html lang="pt-br" dir="ltr">

<?php $this->load->view('painel/incPainelHead'); ?>


<body class="layout-sticky-subnav layout-default ">

    <div class="preloader">
        <div class="sk-double-bounce">
            <div class="sk-child sk-double-bounce1"></div>
            <div class="sk-child sk-double-bounce2"></div>
        </div>
    </div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

<?php $this->load->view('painel/incPainelHeader'); ?>

       <!-- Header Layout Content -->
        <div class="mdk-header-layout__content page-content">

            <div class="mdk-box bg-primary mdk-box--bg-gradient-primary2 js-mdk-box mb-0" data-effects="blend-background">
                <div class="mdk-box__content">
                    <div class="hero py-64pt text-center text-sm-left">
                        <div class="container page__container">
                            <h1 class="text-white"><?php echo $curso[0]->titulo; ?></h1>
                            <p class="lead text-white-50 measure-hero-lead mb-24pt"><?php echo strip_tags($curso[0]->descricao); ?></p>
                            <p class="text-white">
                            	<span class="material-icons icon-30pt icon--left">access_time</span><span class="text-white" style="font-size: 18px; padding-top: 28px; padding-right: 20px;">Carga horária: <?php if($cursopercentual[0]->somatempo) echo $cursopercentual[0]->somatempo; else echo "0"; ?> horas</span>
								<span class="material-icons icon-30pt icon--left">assignment_turned_in</span><span class="text-white" style="font-size: 18px; padding-top: 28px; padding-right: 20px;">Percentual concluído: <?php if($cursopercentual[0]->somatempo) echo ceil($cursopercentual[0]->presenca/$cursopercentual[0]->somatempo*100); else echo "0"; ?>%</span>
                            </p> 
                            
                        </div>
                    </div>
                    <div class="navbar navbar-expand-sm navbar-light bg-white border-bottom-2 navbar-list p-0 m-0 align-items-center">
                    </div>
                </div>
            </div>

            <div class="container page__container">
                <div class="row">
                    <div class="col-lg-12">
                    	
                        <div class="border-left-2 page-section pl-32pt">
                        	
                        	<?php foreach ($modulos as $key => $row) { ?>
                            	<?php $videoaulalista = $this->modelo->videoaulalista($row->id); ?>
                                <div class="d-flex align-items-center page-num-container">
                                    <div class="page-num"><?php echo $key+1; ?></div>
                                    <h4><?php echo $row->nome; ?></h4>
                                </div>
    
                                <p class="text-70 mb-24pt"><?php echo $row->descricao; ?></p>
    
                                <div class="card mb-32pt mb-lg-64pt">
                                    <ul class="accordion accordion--boxed js-accordion mb-0" id="toc-<?php echo $key; ?>">
                                        <li class="accordion__item open">
                                            <a class="accordion__toggle" data-toggle="collapse" data-parent="#toc-<?php echo $key; ?>" href="#toc-content-<?php echo $key; ?>">
                                                Conteúdo
                                                <span class="flex"></span>
                                                <span class="accordion__toggle-icon material-icons">keyboard_arrow_down</span>
                                            </a>
                                            <div class="accordion__menu">
                                                <ul class="list-unstyled collapse show" id="toc-content-<?php echo $key; ?>">
                                                	<?php foreach ($videoaulalista as $key2 => $row2) { ?>
                                                        <li class="accordion__menu-link">
                                                            <?php if((($row2->data_fim >= date('Y-m-d H:i:s')) or ($row2->data_fim == '0000-00-00 00:00:00'))){ ?>
                                                                <?php if((($row2->data_inicio <= date('Y-m-d H:i:s')) or ($row2->data_inicio == '0000-00-00 00:00:00'))){ ?>
                                                                    <?php if($row2->presenca){ ?>
                                                                        <span class="material-icons icon-16pt icon--left text-body" style="color:#006400 !important;">check_circle</span>
                                                                    <?php } else { ?>
                                                                        <span class="material-icons icon-16pt icon--left text-body">play_circle_outline</span>
                                                                    <?php } ?>
                                                                    <a class="flex" href="<?php echo base_url(); ?>painel/videoaula/<?php echo ($row2->id); ?>"><?php echo $row2->titulo; ?></a>
                                                                    <span class="text-muted"><?php echo substr($row2->tempo,0,2); ?>m <?php echo substr($row2->tempo,3,2); ?>s</span>
                                                                <?php } else { ?>
                                                                    <span data-toggle="tooltip" data-placement="bottom" data-title="Liberação de aula em <?php if($row2->data_inicio != '0000-00-00 00:00:00') echo date("d/m/Y", strtotime($row2->data_inicio)); ?>" class="material-icons icon-16pt icon--left text-body" style="color:#a61d24 !important;">lock</span>
                                                                    <a data-toggle="tooltip" data-placement="bottom" data-title="Liberação de aula em <?php if($row2->data_inicio != '0000-00-00 00:00:00') echo date("d/m/Y", strtotime($row2->data_inicio)); ?>" class="flex"><?php echo $row2->titulo; ?></a>
                                                                    <span data-toggle="tooltip" data-placement="bottom" data-title="Liberação de aula em <?php if($row2->data_inicio != '0000-00-00 00:00:00') echo date("d/m/Y", strtotime($row2->data_inicio)); ?>" class="text-muted"><?php echo substr($row2->tempo,0,2); ?>m <?php echo substr($row2->tempo,3,2); ?>s</span>
                                                                <?php } ?>
                                                            <?php } else { ?>
                                                                <span data-toggle="tooltip" data-placement="bottom" data-title="Acesso expirado em <?php echo date("d/m/Y", strtotime($row2->data_fim)); ?>" class="material-icons icon-16pt icon--left text-body" style="color:#a61d24 !important;">lock</span>
                                                                <a data-toggle="tooltip" data-placement="bottom" data-title="Acesso expirado em <?php echo date("d/m/Y", strtotime($row2->data_fim)); ?>" class="flex"><?php echo $row2->titulo; ?></a>
                                                                <span data-toggle="tooltip" data-placement="bottom" data-title="Acesso expirado em <?php echo date("d/m/Y", strtotime($row2->data_fim)); ?>" class="text-muted"><?php echo substr($row2->tempo,0,2); ?>m <?php echo substr($row2->tempo,3,2); ?>s</span>
                                                            <?php } ?>
                                                        </li>
                                                    <?php } ?>
    
                                                </ul>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- // END Header Layout Content -->
        

<?php $this->load->view('painel/incPainelFooter'); ?>

    </div>
    <!-- // END Header Layout -->

<?php $this->load->view('painel/incPainelMenu'); ?>

<?php $this->load->view('painel/incPainelScripts'); ?>

</body>

</html>
