<!doctype html>
<html lang="pt-br">

<?php $this->load->view('includes/incHead'); ?>

<body>

    <div class="page-container">


<?php $this->load->view('includes/incHeader'); ?>


<main class="main-container">
<div class="content-container page-course">
<section class="course-presentation-container " style="background-color: #F6B53E; --background-image: url('https://d2knvm16wkt3ia.cloudfront.net/background-image/adobe-illustrator-cc-basico.svg')">
    <ul class="course-categories-list filter-white">
        <li class="course-category">
            <img class="category-logo tw-lazy" data-src="<?php echo base_url(); ?>iportal/public/biblioteca-de-arquivos/produto_categoria/<?php echo $produto[0]->catimagem; ?>" alt="Adobe Illustrator CC - Básico">
        </li>
    </ul>
    <div class="section-container">
        <header class="course-presentation-header">
            <h1 class="section-title tc-white">
                <span class="course-name-prefix upper">
                <?php if($produto[0]->tipo == '2') { ?>
		      		Curso 
		      	<?php }else{ ?>
		      		Produto 
		      	<?php } ?>
                de</span>
                <span class="course-name"><?php echo $produto[0]->crstitulo; ?></span>
            </h1>
            <p class="course-header-presentation-text tc-white"><?php echo $produto[0]->crssubtitulo; ?><?php echo $confIntegracao[0]->integracao; ?></p>
        </header>

        <div class="course-presentation-video-container" id="videoLanding">
            <div class="course-presentation-video-topbar">
                <i class="fas fa-circle tc-red"></i>
                <i class="fas fa-circle tc-yellow"></i>
                <i class="fas fa-circle tc-green"></i>
            </div>
            <div class="video-container">
                <?php if($produto[0]->crsvideo){ ?>
                    <iframe class="sproutvideo-player" src="<?php echo $produto[0]->crsvideo; ?>" frameborder="0" allowfullscreen></iframe>
                <?php } else { ?>
                    <img src="<?php echo base_url(); ?>iportal/public/biblioteca-de-arquivos/curso/<?php echo $produto[0]->crsimagem; ?>"/>
                <?php } ?>
            </div>
        </div>

        <div class="page-courses-plans-container">
            <div class="flip-container tw-switch-container ta-center" data-flip-controller="switchplans01">
                <div class="flipper">
                    <div class="front">
                        <div class="plan-card tw-card">
                            <header class="plan-card-header">
                                <div class="plan-price-container tc-white">
                                	
            <form class="contact-form tw-form" id="form-produto" name="form-produto" method="POST" action="<?php if($produto[0]->compra_unica){ ?><?php echo base_url();?>pagamento<?php } ?>" enctype="multipart/form-data">
                <input type="hidden" name="produto" id="produto" value="<?php echo $produto[0]->id; ?>" />
                <input type="hidden" name="qtdade_vendida" id="qtdade_vendida" value="<?php echo $produto[0]->qtdade_vendida; ?>" />
                <input type="hidden" name="qtdade_saldo" id="qtdade_saldo" value="<?php echo $produto[0]->qtdade_saldo; ?>" />
                <input type="hidden" name="valor" id="valor" value="" />
                <input type="hidden" name="valorunitario" id="valorunitario" value="" />
                <input type="hidden" name="carrinho" id="carrinho" value="" />
                <input type="hidden" name="filiacao" id="filiacao" value="<?php if(!empty($filiacao[0]->usuario)){echo $filiacao[0]->usuario;} ?>" />
                <input type="hidden" name="gratis" id="gratis" value="<?php echo $produto[0]->gratis; ?>" />
				<div style='display:none'>
					<a id="inline-presente">Dados de quem irá receber o presente</a>
						
	                <div id="modal-presente" style='padding:10px; background:#fff;'>
								
									<div id="div_presente">

									</div>

								<!--/ .contact-form--> 
	                            <div id="messageStatusPresente"></div>
	  
	                    <br/><br/>
	                </div>
				
					<!-- /.modal-content -->
				</div>

                <?php if(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
					<input type="hidden" name="cep" value="<?php echo $this->session->userdata('cep');?>" />
					<input type="hidden" name="endereco" value="<?php echo $this->session->userdata('endereco');?>" />
					<input type="hidden" name="bairro" value="<?php echo $this->session->userdata('bairro');?>" />
					<input type="hidden" name="cidade" value="<?php echo $this->session->userdata('cidade');?>" />
					<input type="hidden" name="uf" value="<?php echo $this->session->userdata('uf');?>" />
            	<?php } ?>
                
				<?php if($produto[0]->qtdade_saldo > 0  || $produto[0]->qtdade == '-1'){ ?>
					<?php if($produto[0]->unidade){ ?>
						<?php if(!$produto[0]->carunidade && $produto[0]->carunidade != '0'){ ?>
						<div id="divunidade" style="padding-bottom: 0;" class="price">
							Unidade: 
							<select class="form-input" name="unidade" id="unidade" style="width: 70%;" onchange="geracupom();">
								<?php foreach ($unidade as $key => $row) { ?>
									<option value="<?php echo $row->id; ?>"><?php echo $row->nome.' - R$ '.number_format($row->preco, 2, ',', '.'); ?></option>
								<?php } ?>
							</select>
						</div>
						<?php }else{
							if($produto[0]->carunidade == $produto[0]->unidade){ ?> 
								<div id="divunidade" style="padding-bottom: 0;" class="price">
								Unidade: 
								<select class="form-input" name="unidade" id="unidade" style="width: 70%;" onchange="geracupom();">
									<?php foreach ($unidade as $key => $row) { ?>
										<option value="<?php echo $row->id; ?>"><?php echo $row->nome.' - R$ '.number_format($row->preco, 2, ',', '.'); ?></option>
									<?php } ?>
								</select>
							</div>
							<?php }else{ ?>
								<?php if($this->session->userdata('id')){ ?>
								Este produto não poder adicionado ao carrinho, pois já existe um produto no carrinho diferente da unidade que este pode ser adicionado.
								<?php } ?>
							<?php } ?>
						<?php } ?>
					<?php }else{ ?>
							<?php if($this->session->userdata('id') && $produto[0]->carunidade){ ?>
							Este produto não poder adicionado ao carrinho, pois já existe um produto no carrinho diferente da unidade que este pode ser adicionado.
							<?php } ?>
					<?php } ?>
							<br/>
						<?php if ($produto[0]->gratis) { ?>
		                    <div id="divtotal" style="padding-top: 0;" class="cv-color"><strong>Produto grátis</strong></div>
	                    <?php } else { ?>
							<div id="divpreco" style="padding-bottom: 0;" class="cv-color">Preço unitário: R$ <?php echo number_format($produto[0]->preco, 2, ',', '.'); ?></div>
		                    <div id="divtotal" style="padding-top: 0;" class="cv-color"><strong>Total da compra: R$ <?php echo number_format($produto[0]->preco, 2, ',', '.'); ?></strong></div>
	                    <?php } ?>
						<br/>
						<div class="addtocart-product">
						<?php if ($produto[0]->qtdade_porcompra > '1') { ?>
						
							<?php if ($produto[0]->qtdade == '-1') { ?>
								<div class="product-amount">
								
	                            <select class="form-input" name="qtdade" id="qtdade" style="width: 100%;" onchange="geracupom();">
	                                <?php for ($i = 1; $i <= $produto[0]->qtdade_porcompra; $i++) { ?>
	                                    <option value="<?php echo $i; ?>" <?php if($produto[0]->crnqtdade == $i){ echo "selected";} ?>><?php echo $i; ?></option>
	                                <?php } ?>
	                            </select>
								</div>
								<br/>
							<?php }else{ ?>
								<div class="product-amount">
								
	                            <select class="form-input" name="qtdade" id="qtdade" style="width: 100%;" onchange="geracupom();">
	                                <?php for ($i = 1; $i <= $produto[0]->qtdade_saldo; $i++) { ?>
	                                    <option value="<?php echo $i; ?>" <?php if($produto[0]->crnqtdade == $i){ echo "selected";} ?>><?php echo $i; ?></option>
	                                    <?php if ($produto[0]->qtdade_porcompra && $i >= $produto[0]->qtdade_porcompra) {
									        break;
									    } ?>
	                                <?php } ?>
	                            </select>
								</div>
								<br/>
							<?php } ?>
		                 <?php }else{ ?>
		                     	<input type="hidden" name="qtdade" id="qtdade" value="<?php echo $produto[0]->qtdade_porcompra; ?>" />
						 <?php } ?>
								
	                     <?php if($this->session->userdata('id') || $produto[0]->usuariooff == '1'){ ?>
								<?php if(empty($produto[0]->carrinhoid) || $produto[0]->usuariooff == '1'){ ?>
		                        	<?php if($produto[0]->compra_unica){ ?>
		                        		<?php if(!empty($html_pagamentoforma)){ ?>
		                        			<div class="product-amount">
			                        			<select class="form-input" name="pagamentoforma" id="pagamentoforma" style="width: 100%;" onchange="geracupom();">
				                        			<?php echo $html_pagamentoforma; ?>
												</select>
											</div>
											<br/>
	
						        			<?php if($produto[0]->evento && $produto[0]->participante){ ?>
					        				 	<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popParticipante();">EFETUAR PAGAMENTO</a>
											<?php }elseif(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popFrete();">EFETUAR PAGAMENTO</a>
					        				<?php }else{ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="addCarrinho();">EFETUAR PAGAMENTO</a>
											<?php } ?>
											
	                        			<?php } ?>	 
		                        	<?php }elseif($produto[0]->gratis){ ?>
						        			<?php if($produto[0]->evento && $produto[0]->participante){ ?>
					        				 	<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popParticipante();">ADQUIRIR</a>
											<?php }elseif(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popFrete();">ADQUIRIR</a>
					        				<?php }else{ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="addCarrinho();">ADQUIRIR</a>
											<?php } ?>
		                        	<?php }else{ ?>	
			                        	<a href="javascript:void(0);" style="width: 90%;text-align: center;" class="tw-btn default upper bold" onclick="addCarrinho();">COMPRAR </i></a>
			                            <br/><br/><br/>
		                        	<?php } ?>	
		                        	<?php if(!empty($listacupom)){ ?>
				                            <label>Cupom de desconto</label><br/><input class="form-input" type="text" name="cupom" id="cupom" onblur="geracupom();"> <a href="javascript:void(0);" class="tw-btn default upper bold" >VALIDAR CUPOM</a>										
									<?php } ?>
		                            <div id="messageProduto"></div>
		                            <div id="timerstart" style="display: none;"></div>
		                            
								<?php }elseif($produto[0]->unidadeid == $produto[0]->unidade){ ?>
									
		                        	<?php if($produto[0]->compra_unica){ ?>
		                        		<?php if(!empty($html_pagamentoforma)){ ?>
		                        			<div class="product-amount">
			                        			<select name="pagamentoforma" id="pagamentoforma" style="width: 100%;" onchange="geracupom();">
				                        			<?php echo $html_pagamentoforma; ?>
												</select>
											</div>
											<br/>
	
						        			<?php if($produto[0]->evento && $produto[0]->participante){ ?>
					        				 	<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popParticipante();">EFETUAR PAGAMENTO</button>
											<?php }elseif(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popFrete();">EFETUAR PAGAMENTO</a>
					        				<?php }else{ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="addCarrinho();">EFETUAR PAGAMENTO</a>
											<?php } ?>
											
	                        			<?php } ?>	                        		
		                        	<?php }elseif($produto[0]->gratis){ ?>
	
						        			<?php if($produto[0]->evento && $produto[0]->participante){ ?>
					        				 	<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popParticipante();">ADQUIRIR</button>
											<?php }elseif(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="popFrete();">ADQUIRIR</a>
					        				<?php }else{ ?>
												<a href="javascript:void(0);" style="width: 96%;text-align: center;" class="tw-btn default upper bold" onclick="addCarrinho();">ADQUIRIR</a>
											<?php } ?>
                      		
		                        	<?php }else{ ?>
			                        	<a href="javascript:void(0);" style="width: 90%;text-align: center;" class="tw-btn default upper bold" onclick="addCarrinho();">COMPRAR</a>
			                            <br/><br/><br/>
		                        	<?php } ?>	
		                        	<?php if(!empty($listacupom)){ ?>
										
				                            <label>Cupom de desconto</label><br/><input type="text" name="cupom" id="cupom" onblur="geracupom();" style="width: 70%;"> <a style="text-align: center; width: 15%;" href="javascript:void(0);" class="tw-btn default upper bold" >VALIDAR CUPOM</a>
										
									<?php } ?>
		                            <div id="messageProduto"></div>
		                            <div id="timerstart" style="display: none;"></div>	                        	
	                        	<?php } ?>
	                        	<br /><input onClick="addPresente();" type="checkbox" name="presente" id="presente" value="1" /> Esta compra é um presente.
	                        <?php } else { ?>
	                            <br/><br/><br/>
	                            <a class="tw-btn default upper bold" href="<?php echo base_url();?>login/pagina"> Comprar </a>
	                            <a href="<?php echo base_url();?>usuario" class="tw-btn default upper bold"> Cadastrar-se </a>

	                        <?php } ?>    
								</div>
					<?php }else{ ?>
						<br/>
						<div class="divider-half-line"></div>
						<h4>Produto esgotado.</h4>
					<?php } ?>

				<div class="divider-half-line"></div>
				<br />
                <div class="categories-product">Categoria: <a href="<?php echo base_url(); ?>produto/categoria/<?php echo $produto[0]->categoriaid; ?>"><?php echo $produto[0]->categorianome; ?></a></div>

      </form>


                                </div>
                            </header>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
        <section class="course-info-container">
            <div class="section-container" >
                <section class="course-about-container">
    <h3 class="course-about-title">Sobre o curso</h3>
    <p class="course-about-paragraph">
    	<?php echo $produto[0]->sobre; ?>
</p>

    <h3 class="course-about-title">Conhecimentos adquiridos</h3>
    <p class="course-about-paragraph">
    	<?php echo $produto[0]->conhecimentos; ?>
</p>

    <h3 class="course-about-title">Para quem é esse curso?</h3>
    <p class="course-about-paragraph">
    	<?php echo $produto[0]->para_quem; ?>
</p>
    </section>
                <section class="course-data-container">
    <div class="tw-card">
        <dl class="tw-small-list">
            <dt class="tw-small-list-title fs-20 bold">Metodologia</dt>
                <dd class="tw-small-list-item"><i class="ta-center fas fa-play"></i> Videoaulas</dd>
                            <dd class="tw-small-list-item"><i class="ta-center far fa-clock"></i> Início imediato</dd>
                <dd class="tw-small-list-item"><i class="ta-center far fa-file-alt"></i> Exemplos práticos</dd>

            
                    </dl>
    </div>
</section>
            </div>
        </section>

<section class="course-content-container">
    <div class="section-container">
        <div class="course-content-top">
            <h2 class="section-title related-courses-title">Conteúdo Programático</h2>
        </div>
        <hr class="tw-hr content">
        <?php if (!empty($cursomodulo)) { ?>
            <?php foreach ($cursomodulo as $key => $row) { ?>
                <?php $cursomoduloitem = $this->modelo->cursomoduloitem($row->id); ?>
                <?php if (!empty($cursomoduloitem)) { ?>
                    <dl class="tw-simple-list">
                        <dt class="tw-simple-list-item-title bold"><?php echo $key+1; ?> - <?php echo $row->nome; ?></dt>
                        <?php foreach ($cursomoduloitem as $key2 => $row2) { ?>
                            <dd class="tw-simple-list-item">
                            <i class="fas fa-play"></i>
                            <?php echo $row2->item; ?>
                            </dd>
                        <?php } ?>
                    </dl>
                <?php } ?>
            <?php } ?>
        <?php } ?>
    </div>
</section>




<section class="related-courses-container">
    <?php if(!empty($produto_comprado)){ ?>
        <div class="section-container">
            <h2 class="section-title related-courses-title">QUEM COMPROU ESTE PRODUTO TAMBÉM ADQUIRIU</h2>
            <hr class="tw-hr content">
            <ul class="courses-list">
                <?php foreach ($produto_comprado as $key => $row) { ?>
                    <div>
                        <li class="courses-list-item <?php if($row->novo) echo "is-new"; ?>" style="color: #FBB040;">
                            <a href="<?php echo base_url();?>produto/<?php echo $row->url_amigavel;?>" class="course-link">
                                <ul class="course-categories-list filter-white">
                                    <li class="course-category">
                                        <img class="category-logo tw-lazy" data-src="<?php echo base_url();?>iportal/public/biblioteca-de-arquivos/produto_categoria/<?php echo $row->catimagem;?>" alt="Fotografia">
                                    </li>
                                </ul>
                                <img class="course-logo" src="<?php echo base_url();?>iportal/public/biblioteca-de-arquivos/curso/<?php echo $row->crsimagem;?>" alt="<?php echo $row->titulo;?>">
                                <span class="course-name tc-white"><?php echo $row->titulo;?></span>
                                <span class="course-name tc-white">
                                	<strong>
                                		<?php if($row->gratis) { ?>
                        		      		Gratis
                        		      	<?php }else{ ?>
                        		      		<?php if($row->preco_original && $row->preco_original != '0.00'){ ?><span class="discount">R$ <?php echo str_replace(".", ",", $row->preco_original); ?></span><?php } ?> R$ <?php echo str_replace(".", ",", $row->preco); ?>
                        		      	<?php } ?>
                                	</strong>
                                </span>
                            </a>
                        </li>
                    </div>
                <?php } ?>
            </ul>
        </div>
    <?php } ?>
</section>

<?php $this->load->view('includes/incPromocoes'); ?>

<section class="content-container-section plans-container" id="plans-container-section">
    <div class="wave-elements-container">
        <div class="wave-clippath-container" >
            <img src="<?php echo base_url(); ?>public/images/logo-seta-2.svg" class="wave-arrows-icon tw-lazy">
            <div class="wave-clippath-wing left-wing" ></div>
            <div class="wave-clippath-bar" ></div>
            <div class="wave-clippath-wing right-wing" ></div>
        </div>
    </div>
    <div class="shapes-container">
        <img src="<?php echo base_url(); ?>public/images/img-azul.svg" id="avmf-04" class="avm-shape tw-lazy">
        <img src="<?php echo base_url(); ?>public/images/img-rosa.svg" id="avmf-05" class="avm-shape tw-lazy">
        <img src="<?php echo base_url(); ?>public/images/img-amarela.svg" id="avmf-06" class="avm-shape tw-lazy">
    </div>
    <div class="section-container">
        <?php if(stristr($homedescricao[0]->video, 'youtube')) { ?>
            <?php $codigo_video = explode("/", $homedescricao[0]->video); ?>
            <div class="video-container main-video tw-modal-trigger" data-modal-content="presentation-video-modal" style="background-image: url('https://img.youtube.com/vi/<?php echo $codigo_video[4]; ?>/maxresdefault.jpg');">
                <i class="far fa-play-circle"></i>
                <div id="presentation-video-modal<?php echo $key; ?>" class="tw-iframe-video-container tw-modal-content">
                    <iframe class="tw-iframe" src="<?php echo $homedescricao[0]->video; ?>?autoplay=0" frameborder="0" allowfullscreen="" allow="autoplay"></iframe>
                </div>
            </div>
        <?php } elseif(stristr($homedescricao[0]->video, 'vimeo')) { ?>
            <?php $codigo_video = explode("/", $homedescricao[0]->video); ?>
            <div class="video-container main-video tw-modal-trigger" data-modal-content="presentation-video-modal" style="background-image: url('https://i.vimeocdn.com/video/<?php echo $codigo_video[4]; ?>.webp');">
                <i class="far fa-play-circle"></i>
                <div id="presentation-video-modal<?php echo $key; ?>" class="tw-iframe-video-container tw-modal-content">
                    <iframe class="tw-iframe" src="<?php echo $homedescricao[0]->video; ?>?autoplay=0" frameborder="0" allowfullscreen="" allow="autoplay"></iframe>
                </div>
            </div>
        <?php } ?>
        <div class="plan-card">
            <header class="plan-card-header">
    <h3 class="plan-card-title tc-white upper fs-25"><span class="bold"><?php echo $destaqueprincipal[0]->titulo; ?></span></h3>
        <?php if(!empty($destaqueprincipal_produto[0])){ ?>
    <div class="plan-price-container tc-white">
            <div class="upper">
                <span class="fs-10">de</span>
                <del class="strike">
                    <span class="fs-20">R$<span class="dt-last-price"><?php echo $destaqueprincipal_produto[0]->preco_original; ?></span></span>
                </del>
            </div>
        
        <div>
            <span class="upper fs-10">por:</span>
            <span class="bold fs-30">R$<span class="dt-current-price"><?php echo $destaqueprincipal_produto[0]->preco; ?></span></span>
        </div>
    </div>
            <?php } ?>
</header>
            <ul class="plan-card-list">
            	<?php foreach ($destaqueprincipal as $key => $row) { ?>
                <li class="plan-card-list-item">
                    <i class="fas fa-check tc-green"></i>
                <span class="plan-card-list-item-text"><strong><?php echo $row->nome ;?></strong></span>
    </li>
    <?php } ?>
    
            </ul>
            
	<?php if(!empty($destaqueprincipal[0])){ ?>
	 		<?php if($destaqueprincipal[0]->link_tipo == "I"){ ?>
            <footer class="plan-card-footer">
                <a href="<?php echo base_url();?><?php echo $destaqueprincipal[0]->area;?>/<?php echo $destaqueprincipal[0]->url_amigavel;?>" class="tw-btn default upper bold"><?php echo $destaqueprincipal[0]->link_titulo;?></a>
            </footer>
		  <?php }elseif($destaqueprincipal[0]->link_tipo == "E"){ ?> 
            <footer class="plan-card-footer">
                <a href="<?php echo $destaqueprincipal[0]->url;?>" class="tw-btn default upper bold"><?php echo $destaqueprincipal[0]->link_titulo;?></a>
            </footer>	  
		  <?php } ?>
  <?php } ?>
        </div>
    </div>
</section>

<section class="content-container-section comments-container bc-darkwhite">
    <div class="shapes-container" >
        <img src="<?php echo base_url(); ?>public/images/img-azul.svg" id="avmf-08" class="avm-shape tw-lazy">
        <img src="<?php echo base_url(); ?>public/images/img-amarela.svg" id="avmf-09" class="avm-shape tw-lazy">
    </div>

    <div class="section-container">
        <header class="section-header tc-darkblue ta-center" >
            <h2 class="section-title fw-normal" >Utilizada e amada por milhares!</h2>
            <p class="section-description">
                Confira os depoimentos de quem já estudou com a gente
            </p>
        </header>

        <div class="tw-slider">
            <div class="slider-container" data-nav="comments-pills">
            	
                   <div class="slider-item">
                        <ul class="comments-list">
                        	<?php foreach ($cursodepoimento as $key => $row) { ?>
                               <li class="comments-list-item">
                                    <div class="tw-comment">
                                        <div class="tw-comment-container ani-hover-zoom">
                                            <q class="tw-comment-text">
                                                <?php echo $row->depoimento; ?>
                                            </q>
                                        </div>
                                        <span class="tw-comment-author upper"><?php echo $row->nome; ?> (<?php echo $row->cidade; ?> - <?php echo $row->uf; ?>)</span>
                                        <span class="tw-comment-course bold"><?php echo $row->titulo; ?></span>
                                        <img class="tw-comment-author-picture tw-lazy"
                                             src="<?php echo base_url(); ?>iportal/public/biblioteca-de-arquivos/cursodepoimento/<?php echo $row->imagem; ?>"
                                             alt="<?php echo $row->nome; ?>">
                                    </div>
                                </li>
                             <?php } ?>
                          </ul>
                    </div>
                                    
                                    
                            </div>
        </div>

        <ul id="comments-pills" class="slider-pills-list tw-list-none">
            <li class="slider-pills-list-item">
                <label class="slider-pill-label">
                    <input class="slider-pill" type="radio" name="slides-comments-pill" checked/>
                    <span class="slider-pill-selector"></span>
                </label>
            </li>
            <li class="slider-pills-list-item">
                <label class="slider-pill-label">
                    <input class="slider-pill" type="radio" name="slides-comments-pill"/>
                    <span class="slider-pill-selector"></span>
                </label>
            </li>
            <li class="slider-pills-list-item">
                <label class="slider-pill-label">
                    <input class="slider-pill" type="radio" name="slides-comments-pill"/>
                    <span class="slider-pill-selector"></span>
                </label>
            </li>
        </ul>

        <div class="ta-center mt-40 mb-40">
            <a href="<?php echo base_url(); ?>depoimento" class="tw-btn blank upper bold">Veja mais opiniões reais</a>
        </div>

    </div>
</section>

<?php if(!empty($garantias[0])){ ?>
        <section class="content-container-section warranty-container bc-lightwhite">
    <div class="section-container">
        <header class="section-header tc-darkblue ta-center">
            <h2 class="section-title fw-normal"><strong><?php echo $garantias[0]->titulo; ?></strong></h2>
        </header>
        <div class="warranty-body">
            <div class="warranty-seal-container">
                <img class="warranty-seal tw-lazy" src="<?php echo base_url(); ?>iportal/public/biblioteca-de-arquivos/garantias/<?php echo $garantias[0]->imagem; ?>" alt="Satisfação Garantida - 7 dias ou seu dinheiro de volta!"/>
            </div>
            <div class="warranty-text">
                <?php echo $garantias[0]->texto; ?>
            </div>
	 		<?php if($garantias[0]->link_tipo == "I"){ ?>
            <div class="ta-center clear">
                <a href="<?php echo base_url();?><?php echo $garantias[0]->area;?>/<?php echo $garantias[0]->url_amigavel;?>" class="tw-btn default upper bold"><?php echo $garantias[0]->link_titulo;?></a>
            </div>
		  <?php }elseif($garantias[0]->link_tipo == "E"){ ?> 
            <div class="ta-center clear">
                <a href="<?php echo $garantias[0]->url;?>" class="tw-btn default upper bold"><?php echo $garantias[0]->link_titulo;?></a>
            </div>  
		  <?php } ?>
        </div>
    </div>
</section>
<?php } ?>

<section class="faq-container bc-darkwhite" >
    <div class="section-container" >
        <header class="section-header tc-darkblue ta-center" >
            <h2 class="section-title fw-normal" ><strong>FAQ</strong> - Perguntas Frequentes</h2>
            <p class="section-description" >Confira as principais dúvidas de quem<br>procura o Ehbooks.</p>
        </header>
        <ul class="faq-list" >
        	<?php foreach ($faq as $key => $row) { ?>
            <li class="faq-list-item" >
                <div class="tw-accordion" >
                    <input type="checkbox" class="tw-accordion-check check-unique" id="faq-<?php echo $key; ?>" name="tw-faq" />
                    <label class="tw-accordion-label" for="faq-<?php echo $key; ?>" >
                        <h3 class="tw-accordion-title" >
                            <?php echo strip_tags($row->pergunta); ?>
                        </h3>
                    </label>
                    <div class="tw-accordion-body" >
                    	<?php echo ($row->resposta); ?>
                    </div>
                </div>
            </li>
            <?php } ?>
            
            
            
            
        </ul>
        <div class="ta-center mt-40 mb-40" >
            <a href="<?php echo base_url(); ?>faq" class="tw-btn default upper" >Tenho outra(s) dúvida(s)</a>
        </div>
    </div>
</section>
        </main>


<?php $this->load->view('includes/incFooter'); ?>

            </div>
<?php $this->load->view('includes/incScripts'); ?>

</body>
</html>
<script>

<?php if($this->session->userdata('id') || $produto[0]->usuariooff == '1'){ ?>
	<?php if(!$produto[0]->compra_unica){ ?>
		<?php if($produto[0]->gratis){ ?>
			var addCarrinho = function(){
				if(!validarPresente()){
					return;
				}
			    $('#messageProduto').html("");
			    $('#form-produto').ajaxSubmit({
			        beforeSerialize: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
			        dataType:  'json',
			        url: "<?php echo base_url();?>carrinho/addCarrinho",
			        success: function(resposta) {
			            $('#messageProduto').html(resposta['mensagem']);
			            $(".jquery-waiting-base-container").waiting({modo:"slow"});
			            //window.location = "<?php echo base_url($this->uri->segment(1));?><?php if($this->uri->segment(2)){ echo "/".$this->uri->segment(2); } ?><?php if($this->uri->segment(3)){ echo "/".$this->uri->segment(3); } ?>";
			            window.location = "<?php echo base_url() ?>pagamento/pedidogratis/"+resposta['id'];
			        },
			        error: function (xhr, ajaxOptions, thrownError){
			            //xhr.status : 404, 303, 501...
			            var error = null;
			            switch(xhr.status)
			            {
			                case "301":
			                    error = "Erro de redirecionamento!";
			                    break;
			                case "307":
			                    error = "Erro, redirecionamento de servidor temporário!";
			                    break;
			                case "400":
			                    error = "Solicitação ruim!";
			                    break;
			                case "404":
			                    error = "Página não encontrada!";
			                    break;
			                case "500":
			                    error = "Servidor indisponível no momento!";
			                    break;
			                default:
			                    error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
			            }
			            if(error){
			                $('#messageProduto').html(error);
			                $('#messageProduto').removeClass('color_green').addClass('color_red');
			                $(".jquery-waiting-base-container").waiting({modo:"slow"});
			            }
			        }
			    });
			};
		<?php }else{ ?>
			var addCarrinho = function(){
				if(!validarPresente()){
					return;
				}
			    $('#messageProduto').html("");
			    $('#form-produto').ajaxSubmit({
			        beforeSerialize: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
			        dataType:  'json',
			        url: "<?php echo base_url();?>carrinho/addCarrinho",
			        success: function(resposta) {
			            $('#messageProduto').html(resposta['mensagem']);
			            $(".jquery-waiting-base-container").waiting({modo:"slow"});
			            //window.location = "<?php echo base_url($this->uri->segment(1));?><?php if($this->uri->segment(2)){ echo "/".$this->uri->segment(2); } ?><?php if($this->uri->segment(3)){ echo "/".$this->uri->segment(3); } ?>";
			            window.location = "<?php echo base_url() ?>carrinho";
			        },
			        error: function (xhr, ajaxOptions, thrownError){
			            //xhr.status : 404, 303, 501...
			            var error = null;
			            switch(xhr.status)
			            {
			                case "301":
			                    error = "Erro de redirecionamento!";
			                    break;
			                case "307":
			                    error = "Erro, redirecionamento de servidor temporário!";
			                    break;
			                case "400":
			                    error = "Solicitação ruim!";
			                    break;
			                case "404":
			                    error = "Página não encontrada!";
			                    break;
			                case "500":
			                    error = "Servidor indisponível no momento!";
			                    break;
			                default:
			                    error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
			            }
			            if(error){
			                $('#messageProduto').html(error);
			                $('#messageProduto').removeClass('color_green').addClass('color_red');
			                $(".jquery-waiting-base-container").waiting({modo:"slow"});
			            }
			        }
			    });
			};
		<?php } ?>
	<?php }else{ ?>
		var addCarrinho = function(){
			if(!validarPresente()){
				return;
			}
		    $('#messageProduto').html("");
	        var isValid = true;
	        var msgForm = "";
	        
		    <?php if($produto[0]->evento && $produto[0]->participante){ ?>
		    	qtdpart = $("#qtdade").val();
				htmlpart = "";
				var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
				for(i=1;i<=qtdpart;i++){
	    	        $('#nome'+i+'Status').html("");
	    	        $('#nascimento'+i+'Status').html("");
	    	        $('#email'+i+'Status').html("");
	    	        $('#telefone'+i+'Status').html("");
	    	        $('#cpf'+i+'Status').html("");
			        
			        if(!emailReg.test($('#email'+i).val()) && $('#email'+i).val() != ""){
			            isValid = false;
			            $('#email'+i+'Status').html("E-mail Inválido. Tente novamente.<br />");
			        }
			        if($('#email'+i).val() == ""){
			            isValid = false;
			            $('#email'+i+'Status').html("E-mail é obrigatório.<br />");
			        }
			        if($('#nome'+i).val() == ""){
			            isValid = false;
			            $('#nome'+i+'Status').html("Nome é obrigatório.<br />");
			        }
			        if($('#nascimento'+i).val() == ""){
			            isValid = false;
			            $('#nascimento'+i+'Status').html("Data de nascimento é obrigatório.<br />");
			        }
			        if($('#telefone'+i).val() == ""){
			            isValid = false;
			            $('#telefone'+i+'Status').html("Telefone é obrigatório.<br />");
			        }
			        if($('#nome'+i).val() == ""){
			            isValid = false;
			            $('#cpf'+i+'Status').html("CPF é obrigatório.<br />");
			        }
				}
			<?php }elseif(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
			    $('#freteenderecoStatus').html("");
		        $('#fretebairroStatus').html("");
		        $('#fretecidadeStatus').html("");
		        $('#fretecepStatus').html("");
		        $('#freteufStatus').html("");
		        var isValid = true;
		        if($('#freteendereco').val() == ""){
		            isValid = false;
		            $('#freteenderecoStatus').html("Endereço é obrigatório.<br />");
		        }
		        if($('#fretebairro').val() == ""){
		            isValid = false;
		            $('#fretebairroStatus').html("Bairro é obrigatório.<br />");
		        }
		        if($('#fretecidade').val() == ""){
		            isValid = false;
		            $('#fretecidadeStatus').html("Cidade é obrigatória.<br />");
		        }
		        if($('#fretecep').val() == ""){
		            isValid = false;
		            $('#fretecepStatus').html("CEP é obrigatório.<br />");
		        }
		        if($('#freteuf').val() == ""){
		            isValid = false;
		            $('#freteufStatus').html("Estado é obrigatório.<br />");
		        }
	    	<?php } ?>
	    	if(isValid){
			    $('#form-produto').ajaxSubmit({
			        beforeSerialize: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
			        dataType:  'json',
			        url: "<?php echo base_url();?>carrinho/addCarrinhoUnica",
			        success: function(resposta) {
			        	if(resposta['id']){
			        		if($('#pagamentoforma').val() == '3'){
			        			pagamentoPagseguro();
			        		}else if($('#pagamentoforma').val() == '4'){
			        			pagamentoPaypal();
			        		}else{
			        			<?php if($produto[0]->usuariooff == '1'){ ?>
			        				$('#carrinho').val(resposta['id']);
			        			<?php } ?>
			        			if($('#pagamentoforma').val() == '100'){
			        			    <?php if($confIntegracao[0]->integracao == '2'){ ?>
			        			        $("#form-produto").attr("action", "<?php echo base_url();?>pagamento/pixasaas");
			        			    <?php } else { ?>
			        			        $("#form-produto").attr("action", "<?php echo base_url();?>pagamento/pixdinamico");
			        			    <?php } ?>
			        			}
			        			$( "#form-produto" ).submit();
			        		}
			        	}else{
				            $('#messageProduto').html(resposta['mensagem']);
				            $(".jquery-waiting-base-container").waiting({modo:"slow"});
			        	}
			        },
			        error: function (xhr, ajaxOptions, thrownError){
			            //xhr.status : 404, 303, 501...
			            var error = null;
			            switch(xhr.status)
			            {
			                case "301":
			                    error = "Erro de redirecionamento!";
			                    break;
			                case "307":
			                    error = "Erro, redirecionamento de servidor temporário!";
			                    break;
			                case "400":
			                    error = "Solicitação ruim!";
			                    break;
			                case "404":
			                    error = "Página não encontrada!";
			                    break;
			                case "500":
			                    error = "Servidor indisponível no momento!";
			                    break;
			                default:
			                    error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
			            }
			            if(error){
			                $('#messageProduto').html(error);
			                $('#messageProduto').removeClass('color_green').addClass('color_red');
			                $(".jquery-waiting-base-container").waiting({modo:"slow"});
			            }
			        }
			    });	    		
	    	}

		};
	<?php } ?>
	
	<?php if($produto[0]->evento && $produto[0]->participante){ ?>
	
		var submitMe = function(){
			listaParticipanteHidden();
			addCarrinho();
		}
		
	   var popParticipante = function() {
			listaParticipante();
			$("#inline-participante").colorbox({inline:true, open:true, overlayClose:false, escKey:false, href:"#modal-participante", width:"50%"});
		};
	
		var listaParticipante = function(){
			qtdpart = $("#qtdade").val();
			if(qtdpart=='1'){
				htmlpart = "<center><h3>Informe o participante</h3></center>";	
			}else{
				htmlpart = "<center><h3>Informe os participantes</h3></center>";
			}
					
			htmlpart += '<input onClick="souparticipante();" type="checkbox" name="souparticipante" id="souparticipante" value="1" /> Sou um participante';
			for(i=1;i<=qtdpart;i++){
				htmlpart += '<h5>Participante '+i+' </h5>';
				htmlpart += '<label for="nome">Nome</label>';
				htmlpart += '<input type="text" name="nome['+i+']" id="nome'+i+'" value="" />';
				htmlpart += '<span class="mensagem-alerta" id="nome'+i+'Status"></span>';
				htmlpart += '<label for="nascimento">Data de nascimento</label>';
				htmlpart += '<input class="nascimento" type="text" name="nascimento['+i+']" id="nascimento'+i+'" value="" />';
				htmlpart += '<span class="mensagem-alerta" id="nascimento'+i+'Status"></span>';
				htmlpart += '<label for="email">E-mail</label>';
				htmlpart += '<input type="text" name="email['+i+']" id="email'+i+'" value="" />';
				htmlpart += '<span class="mensagem-alerta" id="email'+i+'Status"></span>';
				htmlpart += '<label for="telefone">Telefone</label>';
				htmlpart += '<input class="telefone" type="text" name="telefone['+i+']" id="telefone'+i+'" value="" />';
				htmlpart += '<span class="mensagem-alerta" id="telefone'+i+'Status"></span>';
				htmlpart += '<label for="cpf">CPF</label>';
				htmlpart += '<input class="cpf" onblur="checaCpf(this, \'cpf'+i+'Status\')" type="text" name="cpf['+i+']" id="cpf'+i+'" value="" />';
				htmlpart += '<span class="mensagem-alerta" id="cpf'+i+'Status"></span><br/>';
				htmlpart += '<input type="checkbox" name="enviar['+i+']" id="enviar'+i+'" value="1" checked /> Enviar e-mail para o participante<br/><br/>';
				
			}
			$("#div_listaParticipante").html(htmlpart);
			$.mask.definitions['~'] = "[+-]";
			$('.telefone').mask("(99)9999-9999?9");
			$('.cpf').mask("999.999.999-99");
			$('.nascimento').mask("99/99/9999");
			
		}
	
		var listaParticipanteHidden = function(){
			qtdpart = $("#qtdade").val();
			htmlpart = "";
			for(i=1;i<=qtdpart;i++){
				htmlpart += '<input type="hidden" name="nome[]" value="'+$("#nome"+i).val()+'" />';
				htmlpart += '<input type="hidden" name="nascimento[]" value="'+$("#nascimento"+i).val()+'" />';
				htmlpart += '<input type="hidden" name="email[]" value="'+$("#email"+i).val()+'" />';
				htmlpart += '<input type="hidden" name="telefone[]" value="'+$("#telefone"+i).val()+'" />';
				htmlpart += '<input type="hidden" name="cpf[]" value="'+$("#cpf"+i).val()+'" />';
				htmlpart += '<input type="hidden" name="enviar[]" value="'+$( "#enviar"+i+":checked" ).length+'"/>';
			}
			$("#form-produto").append(htmlpart);
		}
		
		var souparticipante = function(){
			
	    	if($( "#souparticipante:checked" ).length == 1){
	    		$("#nome1").val("<?php echo $this->session->userdata('nome');?>");
	    		$("#nascimento1").val("<?php echo substr($this->session->userdata('nascimento'), 8,2).'/'. substr($this->session->userdata('nascimento'), 5,2).'/'. substr($this->session->userdata('nascimento'), 0,4) ;?>");
	    		$("#email1").val("<?php echo $this->session->userdata('email');?>");
	    		$("#telefone1").val("<?php echo $this->session->userdata('telcel');?>");
	    		$("#cpf1").val("<?php echo $this->session->userdata('cpf');?>");
	    	}else{
	    		$("#nome1").val("");
	    		$("#nascimento1").val("");
	    		$("#email1").val("");
	    		$("#telefone1").val("");
	    		$("#cpf1").val("");
	    	}
		};
	<?php }elseif(!$produto[0]->evento && $produto[0]->tipo_frete >= '1'){ ?>
	
		var limparFrete = function(){
			    $('#freteendereco').val("");
		        $('#fretebairro').val("");
		        $('#fretecidade').val("");
		        $('#fretecep').val("");
		        $('#freteuf').val("");
		};
	
			
			var calculaFrete = function(){
			        var isValid = true;
			        var msgForm = "";
			        $('#messageProduto').html(msgForm);
			        var params = {
			            'produto'	: $('#produto').val(),
			            'cep'	: $('#fretecep').val()
			        };
			        $.ajax({
			            beforeSend: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
			            type: 'POST',
			            dataType: 'json',
			            url: "<?php echo base_url();?>produto/frete",
			            data: params,
			            success: function(resposta) {
			            	if(resposta['resultado']){
			            		if(resposta['valor']){
			            			htmlpreco = "<h6>Taxa de entrega: R$ "+formataNumero(resposta['valor'],2)+"</h6>";	
			            		}else{
			            			htmlpreco = resposta['mensagem'];
			            		}
				            	$('#frete').val(resposta['valor']);
				            	$('#divfrete').html(htmlpreco);
				            	$("#submit-frete").html('<button onclick="submitMe();" type="button" class="button default" style="width: 100%;"> EFETUAR PAGAMENTO </button>');
			            	}else{
				            	$('#frete').val("");
				            	$('#divfrete').html(resposta['mensagem']);
				            	$("#submit-frete").html('<span class="button_desabilitado" style="width: 92%;">Não há disponibilidade de frete para este CEP.</span>');
			            	}
			            	
			                $(".jquery-waiting-base-container").waiting({modo:"slow"});
			
			            },
			            error: function (xhr, ajaxOptions, thrownError){
			                //xhr.status : 404, 303, 501...
			                var error = null;
			                switch(xhr.status)
			                {
			                    case "301":
			                        error = "Erro de redirecionamento!";
			                        break;
			                    case "307":
			                        error = "Erro, redirecionamento de servidor temporário!";
			                        break;
			                    case "400":
			                        error = "Solicitação ruim!";
			                        break;
			                    case "404":
			                        error = "Página não encontrada!";
			                        break;
			                    case "500":
			                        error = "Servidor indisponível no momento!";
			                        break;
			                    default:
			                        error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
			                }
			                if(error){
			                    $('#messageProduto').html(error);
			                    $('#messageProduto').removeClass('color_green').addClass('color_red');
			                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
			                }
			            }
			        });
			};
			calculaFrete();
	
		var submitMe = function(){
			freteHidden();
			addCarrinho();
		}
	
		var freteHidden = function(){
			qtdpart = $("#qtdade").val();
			htmlfrete = "";
			for(i=1;i<=qtdpart;i++){
				htmlfrete += '<input type="hidden" name="endereco" value="'+$("#freteendereco").val()+'" />';
				htmlfrete += '<input type="hidden" name="bairro" value="'+$("#fretebairro").val()+'" />';
				htmlfrete += '<input type="hidden" name="cidade" value="'+$("#fretecidade").val()+'" />';
				htmlfrete += '<input type="hidden" name="uf" value="'+$("#freteuf").val()+'" />';
				htmlfrete += '<input type="hidden" name="cep" value="'+$("#fretecep").val()+'" />';
				
			}
			$("#form-produto").append(htmlfrete);
		}
		
	   var popFrete = function() {		
			$("#inline-frete").colorbox({inline:true, open:true, overlayClose:false, escKey:false, href:"#modal-frete", width:"50%"});
		};
		
		$.mask.definitions['~'] = "[+-]";
		$('.cep').mask("99.999-999");
	
	<?php } ?>	
		
var pagamentoPaypal = function(){
        var isValid = true;
        var msgForm = "";
        $('#messageCarrinho').html(msgForm);
    if(isValid){
        var params = {
            'forma_pagamento'      : $('#pagamentoforma').val()
        };    	
        $.ajax({
            beforeSend: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
            type: 'POST',
            dataType: 'json',
            url: "<?php echo base_url();?>pagamento/paypal",
            data: params,
            success: function(resposta) { 
            		//alert(resposta['mensagem']);
                    if(resposta['resultado']){
                        $('#form-carrinho').html("");
                        $('#form-pagamento').html("");
                        $('#timerstart').show();
                        starttime(resposta['url_autenticacao'], 10);
        				$('#timerstart').html("<center><h6>Você está sendo redirecionado para o site do PayPal para concluir seu pagamento em <span class='count'>10</span> segundos.</h6></center>");
                    }else{
                    	$('#messageCarrinho').html(resposta['mensagem']);
                    }                    
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
            },
            error: function (xhr, ajaxOptions, thrownError){
                //xhr.status : 404, 303, 501...
                var error = null;
                switch(xhr.status)
                {
                    case "301":
                        error = "Erro de redirecionamento!";
                        break;
                    case "307":
                        error = "Erro, redirecionamento de servidor temporário!";
                        break;
                    case "400":
                        error = "Solicitação ruim!";
                        break;
                    case "404":
                        error = "Página não encontrada!";
                        break;
                    case "500":
                        error = "Servidor indisponível no momento!";
                        break;
                    default:
                        error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                }
                if(error){
                    $('#messageCarrinho').html(error);
                    $('#messageCarrinho').removeClass('color_green').addClass('color_red');
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
                }
            }
        });
    }else{
        $('#messageCarrinho').html(msgForm);
        $('#messageCarrinho').removeClass('color_green').addClass('color_red');
    }
};

var pagamentoPagseguro = function(){
        var isValid = true;
        var msgForm = "";
        $('#messageCarrinho').html(msgForm);
    if(isValid){
        var params = {
            'forma_pagamento' : $('#pagamentoforma').val()
        };    	
        $.ajax({
            beforeSend: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
            type: 'POST',
            dataType: 'json',
            url: "<?php echo base_url();?>pagamento/pagseguro",
            data: params,
            success: function(resposta) { 
            		//alert(resposta['mensagem']);
                    if(resposta['resultado']){
                        $('#form-carrinho').html("");
                        $('#form-pagamento').html("");
                        $('#timerstart').show();
                        starttime(resposta['url_autenticacao'], 10);
        				$('#timerstart').html("<center><h6>Você está sendo redirecionado para o site do PagSeguro para concluir seu pagamento em <span class='count'>10</span> segundos.</h6></center>");
                    }else{
                    	$('#messageCarrinho').html(resposta['mensagem']);
                    }                    
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
            },
            error: function (xhr, ajaxOptions, thrownError){
                //xhr.status : 404, 303, 501...
                var error = null;
                switch(xhr.status)
                {
                    case "301":
                        error = "Erro de redirecionamento!";
                        break;
                    case "307":
                        error = "Erro, redirecionamento de servidor temporário!";
                        break;
                    case "400":
                        error = "Solicitação ruim!";
                        break;
                    case "404":
                        error = "Página não encontrada!";
                        break;
                    case "500":
                        error = "Servidor indisponível no momento!";
                        break;
                    default:
                        error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                }
                if(error){
                    $('#messageCarrinho').html(error);
                    $('#messageCarrinho').removeClass('color_green').addClass('color_red');
                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
                }
            }
        });
    }else{
        $('#messageCarrinho').html(msgForm);
        $('#messageCarrinho').removeClass('color_green').addClass('color_red');
    }
};
 
var starttime = function(url, count){
    var timer = $.timer(
            function() {
                    count--;
                    if(count>0){
                            $('.count').html(count);
                    }else if(count==0){
                            window.location = url;
                    }
            },
            1000,
            true
    );	
};    

var addPresente = function(){
	
	if($( "#presente:checked" ).length){
		htmlpresente = '<div class="contact-form tw-form">';
		htmlpresente += '<h1 class="p25">Dados de quem irá receber o presente</h1></br>'; 
		htmlpresente += '<input class="form-input" type="text" name="presentenome" id="presentenome" placeholder="Nome" value="" /><br /><br />';
		htmlpresente += '<span class="mensagem-alerta" id="presentenomeStatus"></span>';
		htmlpresente += '<input class="form-input nascimento" type="text" name="presentenascimento" id="presentenascimento" placeholder="Data de nascimento" value="" /><br /><br />';
		htmlpresente += '<span class="mensagem-alerta" id="presentenascimentoStatus"></span>';
		htmlpresente += '<input class="form-input" type="text" name="presenteemail" id="presenteemail" placeholder="E-mail" value="" /><br /><br />';
		htmlpresente += '<span class="mensagem-alerta" id="presenteemailStatus"></span>';
		htmlpresente += '<input class="form-input telefone" type="text" name="presentetelefone" id="presentetelefone" placeholder="Telefone" value="" /><br /><br />';
		htmlpresente += '<span class="mensagem-alerta" id="presentetelefoneStatus"></span>';
		htmlpresente += '<input class="form-input cpf" onblur="checaCpf(this, \'presentecpfStatus\')" type="text" name="presentecpf" id="presentecpf" placeholder="CPF" value="" /><br /><br />';
		htmlpresente += '<span class="mensagem-alerta" id="presentecpfStatus"></span><br/>';
		htmlpresente += '<input type="checkbox" onclick="addPresenteTextarea()" name="presenteenviar" id="presenteenviar" value="1" /> Enviar e-mail para a pessoa que receberá um presente.<br/><br />';
		htmlpresente += '<div id="div_presentetextarea"></div><br/>';
		htmlpresente += '<h6>Após o preenchimento dos campos, feche a janela e clique em "Efetuar pagamento" para continuar.</h6>';
		htmlpresente += '</div>';

		$("#div_presente").html(htmlpresente);
		$.mask.definitions['~'] = "[+-]";
		$('.telefone').mask("(99)9999-9999?9");
		$('.cpf').mask("999.999.999-99");
		$('.nascimento').mask("99/99/9999");
		
		$("#inline-presente").colorbox({inline:true, open:true, overlayClose:false, escKey:false, href:"#modal-presente", width:"50%"});
	}else{
		$("#div_presente").html("");
	}
}

var addPresenteTextarea = function(){
	if($( "#presenteenviar:checked" ).length){
		htmltextarea = '<br /><label for="mensagem">Deixe sua mensagem</label>';
		htmltextarea += '<br /><textarea style="width: 99%;" name="presentemensagem" id="presentemensagem"></textarea>';
		htmltextarea += '<span class="mensagem-alerta" id="presentemensagemStatus"></span>';
		$("#div_presentetextarea").html(htmltextarea);
	}else{
		$("#div_presentetextarea").html("")
	}
}

var checaCpf = function(cpf,cpfstatus){
    if(cpf.value != "___.___.___-__"){
	    var isValid = true;
	    var msgForm = "";    
	    $('#'+cpfstatus).html(msgForm);
	    if(isValid){
	        var params = {
	            'cpf' : cpf.value
	        };
	        $.ajax({
	            type: "POST",
	            url: "<?php echo base_url();?>produto/validacpf",
	            data: params,
	            success: function(response){
	                if(response){
	                    $('#'+cpfstatus).html(response);
	                    $( cpf ).focus();
	                }
	            }
	        });
	    }
    }
};

var validarPresente = function(){

	var isValid = true;

	if($( "#presente:checked" ).length){
	    $('#presentenomeStatus').html("");
	    $('#presentenascimentoStatus').html("");
	    $('#presenteemailStatus').html("");
	    $('#presentetelefoneStatus').html("");
	    $('#presentecpfStatus').html("");
	
		var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
	    
	    if(!emailReg.test($('#presenteemail').val()) && $('#presenteemail').val() != ""){
	        isValid = false;
	        $('#presenteemailStatus').html("E-mail Inválido. Tente novamente.<br />");
	    }
	    if($('#presenteemail').val() == ""){
	        isValid = false;
	        $('#presenteemailStatus').html("E-mail é obrigatório.<br />");
	    }
	    if($('#presentenome').val() == ""){
	        isValid = false;
	        $('#presentenomeStatus').html("Nome é obrigatório.<br />");
	    }
	    /*if($('#presentenascimento').val() == ""){
	        isValid = false;
	        $('#presentenascimentoStatus').html("Data de nascimento é obrigatório.<br />");
	    }*/
	    if($('#presentetelefone').val() == ""){
	        isValid = false;
	        $('#presentetelefoneStatus').html("Telefone é obrigatório.<br />");
	    }
	    /*if($('#presentecpf').val() == ""){
	        isValid = false;
	        $('#presentecpfStatus').html("CPF é obrigatório.<br />");
	    }*/
	    if($( "#presenteenviar:checked" ).length){
		    if($('#presentemensagem').val() == ""){
		        isValid = false;
		        $('#presentemensagemStatus').html("A mensagem deve ser preenchida é obrigatório.<br />");
		    }
	    }
	}

    if(isValid){
    	return true;
    }else{
    	$("#inline-presente").colorbox({inline:true, open:true, overlayClose:false, escKey:false, href:"#modal-presente", width:"50%"});
    	return false;
    }
}

<?php } ?>
<?php if(!$produto[0]->gratis){ ?>
	var geracupom = function(){
	        var isValid = true;
	        var msgForm = "";
	        $('#messageProduto').html(msgForm);
	        var params = {
	            'cupom'     : $('#cupom').val(),
	            'produto'	: $('#produto').val(),
	            'qtdade'	: $('#qtdade').val(),
	            'unidade'	: $('#unidade').val(),
	            'pagamentoforma': $("#pagamentoforma").val()
	        };
	        $.ajax({
	            beforeSend: function() {$(".jquery-waiting-base-container").waitingShow({modo:"slow"});},
	            type: 'POST',
	            dataType: 'json',
	            url: "<?php echo base_url();?>produto/cupom",
	            data: params,
	            success: function(resposta) {

	                $('#messageProduto').html(resposta['mensagem']);
	                $('#pagamentoforma').html(resposta['html_pagamentoforma']);
	            	$('#valorunitario').val(resposta['preco']);

	            	if(resposta['precosemdesconto']){
		            	htmlpreco = "Preço unitário: R$ "+number_format(resposta['precosemdesconto'],2,",",".")+"<br/>";
	            	}else{
	            		htmlpreco = "Preço unitário: R$ "+number_format(resposta['preco'],2,",",".")+"<br/>";
	            	}

	            	if(resposta['descontocupom']){
	            		htmlpreco += "Desconto de cupom: R$ "+number_format(resposta['descontocupom'],2,",",".")+"<br/>";
	            	}

	            	if(resposta['desconto']){
	            		htmlpreco += "Desconto: R$ "+number_format(resposta['desconto'],2,",",".")+"<br/>";
	            	}

	            	if(resposta['acrescimo']){
	            		htmlpreco += "Acréscimo: R$ "+number_format(resposta['acrescimo'],2,",",".")+"<br/>";
	            	}

	            	if(resposta['precosemdesconto']){
	            		htmlpreco += "Preço com desconto: R$ "+number_format(resposta['preco'],2,",",".");
	            	}

	            	$('#divpreco').html(htmlpreco);
	            	$('#divtotal').html("<strong>Total da compra: R$ "+number_format(resposta['total'],2,",",".")+"</strong>");
	            	$('#valor').val(resposta['total']);

	                $(".jquery-waiting-base-container").waiting({modo:"slow"});
	
	            },
	            error: function (xhr, ajaxOptions, thrownError){
	                //xhr.status : 404, 303, 501...
	                var error = null;
	                switch(xhr.status)
	                {
	                    case "301":
	                        error = "Erro de redirecionamento!";
	                        break;
	                    case "307":
	                        error = "Erro, redirecionamento de servidor temporário!";
	                        break;
	                    case "400":
	                        error = "Solicitação ruim!";
	                        break;
	                    case "404":
	                        error = "Página não encontrada!";
	                        break;
	                    case "500":
	                        error = "Servidor indisponível no momento!";
	                        break;
	                    default:
	                        error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
	                }
	                if(error){
	                    $('#messageProduto').html(error);
	                    $('#messageProduto').removeClass('color_green').addClass('color_red');
	                    $(".jquery-waiting-base-container").waiting({modo:"slow"});
	                }
	            }
	        });			
	};	
	geracupom();

<?php } ?>
</script> 