<!DOCTYPE html>
<html lang="pt-br" dir="ltr">

<?php $this->load->view('painel/incPainelHead'); ?>

<style>
    .chamado_selecao:hover{
        background-color: #E8E8E8;
        cursor: pointer;
    }
</style>

<body class="layout-sticky-subnav layout-default ">

    <div class="preloader">
        <div class="sk-double-bounce">
            <div class="sk-child sk-double-bounce1"></div>
            <div class="sk-child sk-double-bounce2"></div>
        </div>
    </div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

<?php $this->load->view('painel/incPainelHeader'); ?>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content page-content ">



            <div class="pt-32pt">
                <div class="container page__container d-flex flex-column flex-md-row align-items-center text-center text-sm-left">
                    <div class="flex d-flex flex-column flex-sm-row align-items-center mb-24pt mb-md-0">
                        <div class="mb-24pt mb-sm-0 mr-sm-24pt">
                            <h2 class="mb-0"><span class="material-icons sidebar-menu-icon sidebar-menu-icon--left" style="font-size: 33px !important; padding-bottom: 2px;">message</span>Suporte</h2><br />

                        </div>
                    </div>

                </div>
            </div>



            <div class="container page__container">



		
			<?php if($this->session->userdata('id')) { ?>
                            
                            <?php if(!empty($lista)) { ?>
                                <h3>Chamados</h3><br/>
                                
                                <div class="card mb-lg-32pt">
                                    <div class="table-responsive" data-toggle="lists" data-lists-sort-by="js-lists-values-date" data-lists-sort-desc="true" data-lists-values='["js-lists-values-name", "js-lists-values-company", "js-lists-values-phone", "js-lists-values-date"]'>
                                        <table class="table mb-0 thead-border-top-0 table-nowrap">
                                            <thead>
                                                <tr class="chamado_th">
                                                    <th>Número</th>
                                                    <th>Data</th>
                                                    <th>Chamado</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody class="list" id="clients">
                                                <?php foreach ($lista as $row) { ?>
                                                    <tr class="chamado_selecao chamado_tr" onclick="window.location = '<?php echo base_url(); ?>suporte/chamado/<?php echo $row->id; ?>'">
                                                        <td><?php echo sprintf("%05d", $row->id); ?></td>
                                                        <td><?php echo date("d/m/Y", strtotime($row->data)); ?></td>
                                                        <td><?php echo $row->assunto; ?></td>
                                                        <td <?php if($row->status == '1'){echo 'style="color:green;"';}else{ echo 'style="color:red;"';} ?>><?php if($row->status == '1'){echo "Respondido";}else{ echo "Pendente";} ?></td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                    <!--/ .columns-->
                                <hr />
                            <?php } ?>
                            <h3>Novo chamado</h3>
                                <form id="form-chamado" method="POST" action="<?php echo base_url();?>suporte/addChamado" enctype="multipart/form-data">

                        <div class="flex" style="max-width: 100%">
                            <div class="was-validated">

                            <div class="form-group">
                                        <input type="text" class="form-control" id="assunto" name="assunto" placeholder="Assunto" value="" required="">
                                        <div class="invalid-feedback">Assunto é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>

                            <div class="form-group">
                                        <textarea class="form-control" name="mensagem" id="mensagem" placeholder="Mensagem" required=""></textarea>
                                        <div class="invalid-feedback">Mensagem é um campo obrigatório.</div>
                                        <div class="valid-feedback"></div>
                            </div>
                            
                            <div class="media-body">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="imagem" name="imagem" accept="image/*">
                                    <label class="custom-file-label" for="inputGroupFile01">Selecionar imagem</label>
                                </div>
                            </div>
                            <br/>
						<button type="button" style="width: 100%; text-align: center;" class="btn btn-primary" href="javascript:void(0)" onClick="addChamado()" id="submit">Enviar</button>
					<br /><br /><br />
					
					</div>
					</div>
				</form>    
                            <div id="messageChamado"></div>
                        <?php }else{ ?>
                            <center>É necessário estar logado para visualizar os chamados ou abrir um chamado.</center>
                        <?php } ?>   


            </div>




        </div>
        <!-- // END Header Layout Content -->


<?php $this->load->view('painel/incPainelFooter'); ?>


    </div>
    <!-- // END Header Layout -->




<?php $this->load->view('painel/incPainelMenu'); ?>



<?php $this->load->view('painel/incPainelScripts'); ?>

</body>
</html>
<script>
var addChamado = function(){
        var isValid = true;
        var msgForm = "";
        $('#assuntoStatus').html("");
        $('#mensagemStatus').html("");
        $('#messageChamado').html(msgForm);

        if($('#form-chamado [name=mensagem]').val() == ""){
            isValid = false;
            $('#form-chamado [name=mensagem]').focus();
        }

        if($('#form-chamado [name=assunto]').val() == ""){
            isValid = false;
            $('#form-chamado [name=assunto]').focus();
        }

        if(isValid){
            
            $('#form-chamado').ajaxSubmit({
                beforeSerialize: function() {$("#submit").html("Enviando...");},
                dataType:  'json',
                url: "<?php echo base_url();?>suporte/addChamado",
                success: function(resposta) { 
                    $('#messageChamado').html("<center><h4 class='color_green'>"+resposta['mensagem']+"</h4></center>");
                    if(resposta['id']){
                        window.location = "<?php echo base_url($this->uri->segment(1));?><?php if($this->uri->segment(2)){ echo "/".$this->uri->segment(2); } ?><?php if($this->uri->segment(3)){ echo "/".$this->uri->segment(3); } ?>";
                    }                    
                },
                error: function (xhr, ajaxOptions, thrownError){
                    //xhr.status : 404, 303, 501...
                    var error = null;
                    switch(xhr.status)
                    {
                        case "301":
                            error = "Erro de redirecionamento!";
                            break;
                        case "307":
                            error = "Erro, redirecionamento de servidor temporário!";
                            break;
                        case "400":
                            error = "Solicitação ruim!";
                            break;
                        case "404":
                            error = "Página não encontrada!";
                            break;
                        case "500":
                            error = "Servidor indisponível no momento!";
                            break;
                        default:
                            error ="Erro inesperado, por favor, <br />tente novamente mais tarde.";
                    }
                    if(error){
                        $('#messageChamado').html("<center><h4 class='color_red'>"+error+"</h4></center>");
                        $(".jquery-waiting-base-container").waiting({modo:"slow"});
                    }
                }
            });
        }else{
            $('#messageChamado').html("<center><h4 class='color_red'>"+msgForm+"</h4></center>");
        }
};
</script>