<?php

    class Usuario extends MX_Controller {
        
        function index($afiliado=''){
        	$this->my_configuracao->confSess();
            $this->load->model('usuariomodel', 'modelo');
            $data['uf'] = $this->modelo->uf();
            $data['usuario'] = $this->modelo->buscaregistro($this->session->userdata('id'));
			$data['afiliado'] = $afiliado;
            $this->load->view('usuarioview', $data);
        }        
 
        function painel($afiliado=''){
         	$this->my_acesso->logged();
        	$this->my_configuracao->confSess();
            $this->load->model('usuariomodel', 'modelo');
            $data['uf'] = $this->modelo->uf();
            $data['usuario'] = $this->modelo->buscaregistro($this->session->userdata('id'));
			$data['afiliado'] = $afiliado;
			$data['menu'] = '6';
            $this->load->view('usuariopainelview', $data);
        } 
        
        function salvar(){
	        $this->my_configuracao->confSess();
			$retorno = '';
            $this->load->model('usuariomodel','modelo');
            $imagemNome = $this->modelo->inserearquivo("imagem");
            $retornosalva = $this->modelo->salva($imagemNome);
            if($retornosalva['id']){
            	if($retornosalva['acao'] == '1'){
			       // BIBLIOTECA my_acesso
			        $query = $this->my_acesso->validate();
		            if ($query) { // VERIFICA LOGIN E SENHA
		                $data['id'] = $this->session->userdata('id');
		            } else {
		                $this->session->sess_destroy();
		            }
	                $retorno = "Obrigado por se cadastrar no site da ".$this->session->userdata('nome_projeto').".</br>";
            	}elseif($retornosalva['acao'] == '2'){
	                $retorno = "Seu cadastro foi atualizado com sucesso.</br>";
            	}
                if(!$this->session->userdata('id')){
                    if (!$this->input->post('senha')){
                        if($this->modelo->geratoken($retornosalva['id'])){
                            $retorno .= "Enviamos para o seu e-mail uma mensagem para definição de senha.";
                        }else{
                            $retorno .= "Houve erro ao tentar gerar a senha. Contate o administrador do sistema.";
                        }
                    }
                }
            }else{
                $retorno = "Houve erro ao tentar salvar.".$retornosalva['id'];
            }
        echo $retorno;        
        }    

        function salvarpre(){
			$retorno = '';
            $this->load->model('usuariomodel','modelo');
            $retornosalva = $this->modelo->salvapre();
            if($retornosalva['id']){
	                $retorno = "Obrigado por se cadastrar do site da ".$this->session->userdata('nome_projeto').".</br>";
	                $this->session->set_userdata('pre_email', $this->input->post('email'));
					$this->session->set_userdata('pre_nome', $this->input->post('nome'));
            }else{
                $retorno = "Houve erro ao tentar salvar.".$retornosalva['id'];
            }
            echo $retorno;        
        }

        function salvarendereco(){
			$retornosalva = '';
            $this->load->model('usuariomodel','modelo');
            $retornosalva = $this->modelo->salvaendereco();
        	echo $retornosalva;        
        }
        
        function existecpf(){
            $retorno = "";
            $this->load->model('usuariomodel', 'modelo');
            if($this->modelo->cpfexiste()){
                $retorno = "Esta identificação já pertence a um usuário.<br />";
            }else{
                if($this->input->post('pessoa') == 'F'){
                    if(!$this->validaCPF($this->input->post('cpf'))){
                        $retorno = "Este CPF é inválido.<br />";
                    }
                }else{
                    if(!$this->validaCNPJ($this->input->post('cpf'))){
                        $retorno = "Este CNPJ é inválido.<br />";
                    }
                }
            }
            echo $retorno;
        }      
        
        function existeemail(){
            $retorno = "";
            $this->load->model('usuariomodel', 'modelo');
            if(strtolower($this->input->post('email')) !== strtolower($this->session->userdata('email'))){
                
                if($this->modelo->emailexiste()){
                    $retorno = "Este e-mail já pertence a um usuário. Faça o login para acessar a área restrita.<br/>";
                }
            }
            echo $retorno;        
        }
        
	function validaCPF($cpf = null) {
        $retorno = true;
	    // Verifica se um número foi informado
	    if(empty($cpf)) {
	        $retorno = false;
	    }

	    // Elimina possivel mascara
    	$cpf = preg_replace("/[^0-9]/", "", $cpf);
    	$cpf = str_pad($cpf, 11, '0', STR_PAD_LEFT);

	    // Verifica se o numero de digitos informados é igual a 11 
	    if (strlen($cpf) != 11) {
	        $retorno = false;
	    }
	    // Verifica se nenhuma das sequências invalidas abaixo 
	    // foi digitada. Caso afirmativo, retorna falso
	    else if ($cpf == '00000000000' || 
	        $cpf == '11111111111' || 
	        $cpf == '22222222222' || 
	        $cpf == '33333333333' || 
	        $cpf == '44444444444' || 
	        $cpf == '55555555555' || 
	        $cpf == '66666666666' || 
	        $cpf == '77777777777' || 
	        $cpf == '88888888888' || 
	        $cpf == '99999999999') {
	        $retorno = false;
	     // Calcula os digitos verificadores para verificar se o
	     // CPF é válido
	     } else {
	         
	        for ($t = 9; $t < 11; $t++) {
	             
	            for ($d = 0, $c = 0; $c < $t; $c++) {
	                $d += $cpf{$c} * (($t + 1) - $c);
	            }
	            $d = ((10 * $d) % 11) % 10;
	            if ($cpf{$c} != $d) {
	                $retorno = false;
	            }
	        }
	    }
	    return $retorno;
	}
	
    function validaCNPJ($cnpj = null) {
        $retorno = true;
    	// Verifica se um número foi informado
    	if(empty($cnpj)) {
    		$retorno = false;
    	}
    
    	// Elimina possivel mascara
    	$cnpj = preg_replace("/[^0-9]/", "", $cnpj);
    	$cnpj = str_pad($cnpj, 14, '0', STR_PAD_LEFT);

    	// Verifica se o numero de digitos informados é igual a 11 
    	if (strlen($cnpj) != 14) {
    		$retorno = false;
    	}
    	
    	// Verifica se nenhuma das sequências invalidas abaixo 
    	// foi digitada. Caso afirmativo, retorna falso
    	else if ($cnpj == '00000000000000' || 
    		$cnpj == '11111111111111' || 
    		$cnpj == '22222222222222' || 
    		$cnpj == '33333333333333' || 
    		$cnpj == '44444444444444' || 
    		$cnpj == '55555555555555' || 
    		$cnpj == '66666666666666' || 
    		$cnpj == '77777777777777' || 
    		$cnpj == '88888888888888' || 
    		$cnpj == '99999999999999') {

    		$retorno = false;
    		
    	 // Calcula os digitos verificadores para verificar se o
    	 // CNPJ é válido
    	 } else {
    	 
    		$j = 5;
    		$k = 6;
    		$soma1 = "";
    		$soma2 = "";
    
    		for ($i = 0; $i < 13; $i++) {
    
    			$j = $j == 1 ? 9 : $j;
    			$k = $k == 1 ? 9 : $k;
    
    			$soma2 += ($cnpj{$i} * $k);
    
    			if ($i < 12) {
    				$soma1 += ($cnpj{$i} * $j);
    			}
    
    			$k--;
    			$j--;
    
    		}

    		$digito1 = $soma1 % 11 < 2 ? 0 : 11 - $soma1 % 11;
    		$digito2 = $soma2 % 11 < 2 ? 0 : 11 - $soma2 % 11;

    		$retorno = (($cnpj{12} == $digito1) and ($cnpj{13} == $digito2));
    	    //$retorno = true;
    	}
    	//echo $cnpj;
    	return $retorno;
    }
    }