<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pedido extends MX_Controller {

    function index($pagina_id) {
        
        $resultado = "";
        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['statuscombo'] = $this->modelo->statuscombo();
        $data['produtocombo'] = $this->modelo->produtocombo();
        $data['pagamentoformacombo'] = $this->modelo->pagamentoformacombo();
        $data['view'] = 'pedidoview';
        
        $this->my_template->show($data);
    }

    function produto($pagina_id, $produto) {
        
        $resultado = "";
        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $data['statuscombo'] = $this->modelo->statuscombo();
        $data['pagamentoformacombo'] = $this->modelo->pagamentoformacombo();
		$data['produto'] = $produto;
        $data['view'] = 'pedidoprodutoview';
        
        $this->my_template->show($data);
    }

    function filiacao($pagina_id, $filiacao, $produto) {
        
        $resultado = "";
        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $pedido = $this->modelo->listafiliacao($filiacao, $produto);
        $data['filiacao'] = $this->modelo->filiacao($filiacao);;
		
		
        foreach ($pedido as $key => $row) {
            $resultado .= '<tr>';
            $resultado .= '<td>';
            $resultado .= $row->pedidoid;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->nomeusuario;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->descforma;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->produtonome;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= number_format($row->valor, 2, ',', '.');
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->statusnome;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= '<a href="'.base_url().$pagina[0]->pagina.'/form/'.$pagina[0]->id.'/'.$row->pedidoid.'" class="btn btn-primary btn-circle btn-xl"><i class="fa fa-list"></i>&nbsp;&nbsp;Visualizar</a>';
            $resultado .= '</td>';
            $resultado .= '</tr>';
        }

        $data['lista'] = $resultado;
        $data['view'] = 'pedidofiliacaoview';
        
        $this->my_template->show($data);
    }

    function usuario($pagina_id, $usuario, $afiliado) {
        
        $resultado = "";
        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $pedido = $this->modelo->listausuario($usuario);
		$data['afiliado'] = $afiliado;
        foreach ($pedido as $key => $row) {
            $resultado .= '<tr>';
            $resultado .= '<td>';
            $resultado .= $row->pedidoid;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->nomeusuario;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->descforma;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->produtonome;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= number_format($row->valor, 2, ',', '.');
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= $row->statusnome;
            $resultado .= '</td>';
            $resultado .= '<td>';
            $resultado .= '<a href="'.base_url().$pagina[0]->pagina.'/form/'.$pagina[0]->id.'/'.$row->pedidoid.'" class="btn btn-primary btn-circle btn-xl"><i class="fa fa-list"></i>&nbsp;&nbsp;Visualizar</a>';
            $resultado .= '</td>';
            $resultado .= '</tr>';
        }

        $data['lista'] = $resultado;
        $data['view'] = 'pedidoview';
        
        $this->my_template->show($data);
    }

    function lista_usuario(){
        $this->load->model('pedidomodel','modelo');
		$retorno = "";
        $usuario = $this->modelo->lista_usuario();
        foreach($usuario as $row){
				$retorno .= '<a href="javascript:void(0);" onclick="selecionausuario(\''.$row->id.'\', \''.$row->nome.'\', \''.$this->input->post('linha').'\')">'.$row->nome.' - '.$row->email.' - '.$row->cpf.'</a>'.'<br/>';      
        }

        echo $retorno;
    }

    function form($pagina_id, $id=''){

        ini_set('error_reporting', E_ALL);
        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $data['p'] = $pagina;
        $s = $this->modelo->buscaRegistro($pagina[0]->tabela, $id);
		$data['s'] = $s;
		$g = $this->modelo->item_ingresso($pagina[0]->tabela, $id);
		$html_formulario = "";
		
		$data['configuracao'] = $this->modelo->configuracao();
		$data['html_pedido'] = "
			<strong>Número do pedido:</strong> ".$s[0]->pedidoid."<br/>
	        <strong>Forma de pagamento:</strong> ".$s[0]->descforma."<br/>
	        <strong>E-mail do comprador:</strong> ".$s[0]->usuarioemail."<br/>
	        <strong>Valor total da compra:</strong> R$ ".number_format($s[0]->valortotal,2,',','')."<br/>
	        <strong>Status do pedido:</strong> ".$s[0]->pedidostatus."<br/><br/>";
	        
	        $data['html_pedido'] .= "
	        <strong>Dados do comprador:</strong><br/>
	        <strong>Nome:</strong> ".$s[0]->nomeusuario."<br/>
	        ";
			if($s[0]->cpf){
	        	$data['html_pedido'] .= "<strong>CPF:</strong> ".$s[0]->cpf."<br/>";
			}
			if($s[0]->telcom){
	        	$data['html_pedido'] .= "<strong>Telefone:</strong> ".$s[0]->telcom."<br/>";
			}
			if($s[0]->telcel){
				$data['html_pedido'] .= "<strong>Telefone:</strong> ".$s[0]->telcel."<br/>";
			}
			if($s[0]->endereco){
				$data['html_pedido'] .= "<strong>Endereço:</strong> ".$s[0]->endereco."<br/>";
			}
			if($s[0]->bairro){
				$data['html_pedido'] .= "<strong>Bairro:</strong> ".$s[0]->bairro."<br/>";
			}
			if($s[0]->cidade){
				$data['html_pedido'] .= "<strong>Cidade:</strong> ".$s[0]->cidade."/".$s[0]->uf."<br/>";
			}
				
        if($s[0]->valorcancelado > 0){
        	$data['html_pedido'].= "<strong>Valor do cancelamento:</strong> ".number_format($s[0]->valorcancelado,2,',','')."<br/>";
        }
        if($s[0]->unidade){
        	$data['html_pedido'].= "<strong>Unidade:</strong> ".$s[0]->unidadenome."<br/>";
        }
		if($s[0]->prestenteid){
			$data['html_pedido'] .= "
				<br/>
				Dados da pessoa que receberá este produto como presente:<br/>
				<strong>Nome:</strong> ".$s[0]->presentenome."<br/>
		        <strong>Data de nascimento:</strong> ".date("d/m/Y", strtotime($s[0]->presentenascimento))."<br/>
		        <strong>E-mail:</strong> ".$s[0]->presenteemail."<br/>
		        <strong>Telefone:</strong> ".$s[0]->presentetelefone."<br/>
		        <strong>CPF:</strong> ".$s[0]->presentecpf."<br/>";
		}
		
		
		
        $data['html_pedido'].= "<br/>Lista dos itens:<br/><br/>";	

		$data['html_pedido'].= "
            <table style='width:100%;'>
            <tr>
            <td style='width:20%;text-align:left;margin-bottom:20px;'><b>Descrição</b></td>";
            if($s[0]->tipo == '1'){
	            $data['html_pedido'].= "
	            <td style='width:20%;text-align:left;margin-bottom:20px;'><b>Nº Ticket</b></td>
	            <td style='width:20%;text-align:left;margin-bottom:20px;'><b>Data utilização</b></td>
	            <td style='width:20%;text-align:left;margin-bottom:20px;'><b>Hora utilização</b></td>";
            }
            $data['html_pedido'].= "
            <td style='width:20%;text-align:left;margin-bottom:20px;'><b>Preço</b></td>
            <td style='width:20%;text-align:left;margin-bottom:20px;'><b>Status</b></td>
                        </tr>";  
			
		foreach ($g as $key => $row) {
			$pedidoitem_formulario = $this->modelo->pedidoitem_formulario($row->itemid);
			$html_formulario .= "Dados Complementares:<br/>";
			
			foreach ($pedidoitem_formulario as $key => $rowform) {
				$html_formulario .= "<strong>".$rowform->label.":</strong> ".$rowform->descricao."<br/>";
			}
	    	$data['html_pedido'].= "                  
	            <tr>
		            <td>
		            	".$row->produtonome."
		            </td>";
			if($s[0]->tipo == '1'){
            	$data['html_pedido'].= '
		            <td>
		            	".sprintf("%05d", $row->itemid).'-'.sprintf("%02d", $row->numero)."
		            </td>
		            <td>
		            	<input type="hidden" name="ingressoid[]" id="ingressoid" value="'.$row->ingressoid.'" />
		            	<input type="date" name="entrada_data[]" id="entrada_data" value="'.$row->entrada_data.'" maxlength="20" />
		            </td>
		            <td>
		            	<input type="time" name="entrada_hora[]" id="entrada_hora" value="'.$row->entrada_hora.'" maxlength="20"/>
		            </td>';
			}		
            $data['html_pedido'].= "
		            <td>
		            	R$ ".str_replace(".", ",", $row->preco)."
		            </td>
		            <td>
		            	".$row->pedidoitemstatus."
		            </td>
	            </tr>";
		}
        $data['html_pedido'].= "</table>";
        
        $data['html_pedido'].= $html_formulario;
					
        $data['view'] = 'pedidoformview';
        
        $this->my_template->show($data);
    }    

    function formatabela($pagina_id){

        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $lista = $this->modelo->lista();
        $resultado = ' { "data": [ ';
        
        foreach($lista as $key => $row){
	        	if($key != '0'){
	        		$resultado .=  ',';
	        	}
	        	$acao = "<a href='".base_url().$pagina[0]->pagina."/form/".$pagina[0]->id."/".$row->id."' class='btn btn-primary btn-circle btn-xl'><i class='fa fa-list'></i>&nbsp;&nbsp;Editar</a>";
		      $resultado .=  ' [ ';
	        	if($this->session->userdata('master')) {
	        		$resultado .=  '"",';
	        	}
				$resultado .=  '
					      "'.$row->pedidoid.'",
					      "'.$row->nomeusuario.'",
					      "'.$row->descforma.'",
					      "'.$row->produtonome.'",
					      "'.number_format($row->valor, 2, ',', '.').'",
					      "'.$row->statusnome.'",
					      "'.$acao.'"
					    ]';
        }
        $resultado .= ' ] } ';
        echo $resultado;
    }

    function formatabelaproduto($pagina_id){

        $this->load->model('pedidomodel','modelo');
        $pagina = $this->modelo->buscaPagina($pagina_id);
        $lista = $this->modelo->lista();
        $resultado = ' { "data": [ ';
        
        foreach($lista as $key => $row){
	        	if($key != '0'){
	        		$resultado .=  ',';
	        	}
	        	$acao = "<a href='".base_url().$pagina[0]->pagina."/form/".$pagina[0]->id."/".$row->id."' class='btn btn-primary btn-circle btn-xl'><i class='fa fa-list'></i>&nbsp;&nbsp;Editar</a>";
		      $resultado .=  ' [ ';
				$resultado .=  '
					      "'.$row->pedidoid.'",
					      "'.$row->nomeusuario.'",
					      "'.$row->descforma.'",
					      "'.number_format($row->valor, 2, ',', '.').'",
					      "'.$row->statusnome.'"
					    ]';
        }
        $resultado .= ' ] } ';
        echo $resultado;
    }

    function salvar(){
        $this->my_acesso->token();
        $this->load->model('pedidomodel','modelo');
        $retorno['id'] = $this->modelo->salva();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
			$retorno['resultado'] = true;
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
			$retorno['resultado'] = false;
        }
        echo json_encode($retorno);
    }

   function cancelasistema(){
   		error_reporting(E_ALL);
		ini_set("display_errors", 1 );
        $this->my_acesso->token();
		$cancela_valortoral = 0;
        $this->load->model('pedidomodel','modelo');
		$id = $this->input->post('id');
		$s = $this->modelo->buscaRegistro("", $id);
		$tid = $s[0]->tid;
		
        if(!empty($_POST['qtdade'])){
            foreach($_POST['qtdade'] as $key => $n ) {
            	if(isset($_POST['itemid'.$key])){
					$item = $this->modelo->item($_POST['itemid'.$key]);
					$cancela_valortoral = number_format($cancela_valortoral + ($s[0]->valortotal/$_POST['qtdade'][$key]),2,'.','');
            	}
            } 
        }
        if($this->modelo->cancela($cancela_valortoral)){
            $retorno['mensagem'] = 'Cancelamento efetuado com sucesso.';
            $retorno['resultado'] = true;
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar efetuar cancelamento.';
			$retorno['resultado'] = false;
        }

        echo json_encode($retorno);
    }            
    
   function cancelacompra(){
   		error_reporting(E_ALL);
		ini_set("display_errors", 1 );
        $this->my_acesso->token();
		$cancela_valortoral = 0;
        $this->load->model('pedidomodel','modelo');
		$id = $this->input->post('id');
		$s = $this->modelo->buscaRegistro("", $id);
		
		$configuracao = $this->modelo->configuracao();
		$tid = $s[0]->tid;
		
        if(!empty($_POST['qtdade'])){
            foreach($_POST['qtdade'] as $key => $n ) {
            	if(isset($_POST['itemid'.$key])){
					$item = $this->modelo->item($_POST['itemid'.$key]);
					$cancela_valortoral = number_format($cancela_valortoral + ($s[0]->valortotal/$_POST['qtdade'][$key]),2,'.','');
            	}
            }
        }
		
		$cancela_valortoral_semponto = str_replace(".", "", $cancela_valortoral);
		     
		$ambiente = true; //true para ambiente de produção e false para ambiente de testes
		
		if($ambiente){
			if($item[0]->unidade){
                //Ambiente de produção
                $cielo_numero = $item[0]->cielo_numero; //Número de filiação da cielo. Em produção.
                $chave_cielo = $item[0]->cielo_chave; // Chave de filiação da cielo. Em produção.
			}else{
                //Ambiente de produção
                $cielo_numero = $configuracao[0]->cielo_numero; //Número de filiação da cielo. Em produção.
                $chave_cielo = $configuracao[0]->cielo_chave; // Chave de filiação da cielo. Em produção.
			}

            //Ambiente de produção
            $url = 'https://ecommerce.cielo.com.br/servicos/ecommwsec.do';
			
		}else{
			
            //Ambiente de testes
            $cielo_numero = '1006993069'; //Número de filiação da cielo, neste caso é o exemplo da homologação
            $chave_cielo = '25fbb99741c739dd84d7b06ec78c9bac718838630f30b112d033ce2e621b34f3'; // Chave de filiação da cielo, neste caso é o exemplo da homologação
            
            //Ambiente de testes
            $url = 'https://qasecommerce.cielo.com.br/servicos/ecommwsec.do';
            		                
		}

        $string = "<?xml version='1.0' encoding='ISO-8859-1'?>
        <requisicao-cancelamento id='13368079-dedc-4cdf-9140-84473faf83d4' versao='1.2.1'>
        	<tid>$tid</tid>
        	<dados-ec>
        		<numero>$cielo_numero</numero>
        		<chave>$chave_cielo</chave>
    		</dados-ec>
    		<valor>$cancela_valortoral_semponto</valor>
		</requisicao-cancelamento>";
        //exit($string);
        
        $ch = curl_init();
        flush();
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,  'mensagem=' . $string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSLVERSION, 4);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_FAILONERROR, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 40);
        $resultado = curl_exec($ch);
        curl_close($ch);
        $xml = simplexml_load_string($resultado);
                                
        if($xml->status == '9'){
        	
            if($this->modelo->cancela($cancela_valortoral)){
                $retorno['mensagem'] = 'Transação de cancelamento efetuado pela operadora.';
                $retorno['resultado'] = true;
            }else{
                $retorno['mensagem'] = 'O cancelamento foi processado com sucesso. Mas houve um erro ao tentar cancelar o pedido, por favor contato o administrador do sistema.';
                $retorno['resultado'] = false;
            }
        }else{

            $retorno['mensagem'] = "Transação de cancelamento não efetuada pela operadora.<br/>";
            $retorno['resultado'] = false;
        }       
		//$retorno['mensagem'] .= $string." - ".$cancela_valortoral." status:".$xml->status;
        echo json_encode($retorno);
    }            

   function cancelaingresso(){
   		error_reporting(E_ALL);
		ini_set("display_errors", 1 );
        $this->my_acesso->token();
		$retorno['resultado'] = false;
		$cancela_valortoral = 0;
        $this->load->model('pedidomodel','modelo');
		$id = $this->input->post('id');
		$s = $this->modelo->buscaRegistro("", $id);
		
        if(!empty($_POST['qtdade'])){
            foreach($_POST['qtdade'] as $key => $n ) {
            	if(isset($_POST['itemid'.$key])){
					$item = $this->modelo->item($_POST['itemid'.$key]);
					$cancela_valortoral = number_format($cancela_valortoral + ($s[0]->valortotal/$_POST['qtdade'][$key]),2,'.','');
					if($this->modelo->cancelaingresso($item[0]->qtdade, $_POST['qtdade'][$key], $item[0]->itemid, $item[0]->itemid)){
						$retorno['resultado'] = true;
					}
            	}
            } 
        }
        if($retorno['resultado']){
	        if($this->modelo->cancelapedidoingresso($cancela_valortoral)){
	            $retorno['mensagem'] = 'Tickets cancelados com sucesso.';
	            $retorno['resultado'] = true;
	        }else{
	            $retorno['mensagem'] = 'Houve um erro a tentar cancelar tickets.';
	            $retorno['resultado'] = false;
	        }
        }                        
		//$retorno['mensagem'] .= $string." - ".$cancela_valortoral." status:".$xml->status;
        echo json_encode($retorno);
    } 


   function cancelapaypal(){
   		error_reporting(E_ALL);
		ini_set("display_errors", 1 );
        $this->my_acesso->token();
		$cancela_valortoral = 0;
        $this->load->model('pedidomodel','modelo');
		$id = $this->input->post('id');
		$s = $this->modelo->buscaRegistro("", $id);
		$tid = $s[0]->tid;
		
        if(!empty($_POST['qtdade'])){
            foreach($_POST['qtdade'] as $key => $n ) {
            	if(isset($_POST['itemid'.$key])){
					$item = $this->modelo->item($_POST['itemid'.$key]);
					$cancela_valortoral = number_format($cancela_valortoral + ($s[0]->valortotal/$_POST['qtdade'][$key]),2,'.','');
            	}
            } 
        }
		
		$cancela_valortoral_semponto = str_replace(".", "", $cancela_valortoral);
		     
		$sandbox = false;
		  
		//Baseado no ambiente, sandbox ou produção, definimos as credenciais
		//e URLs da API.
		if ($sandbox) {
			//credenciais da API para o Sandbox
			$user = 'michaell-facilitator_api1.agencia2i.com.br';
			$pswd = 'GJPQBWQEA4N3EQDF';
			$signature = 'AfF1OPAAGPPtDeDVLAv-wHm7YS9UAN4ech2Od.GhkUjVYhNTS4GLJR1k';
		  
			//URL da PayPal para redirecionamento, não deve ser modificada
			$paypalURL = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		} else {
			//credenciais da API para produção
			$user = 'usuario';
			$pswd = 'senha';
			$signature = 'assinatura';
		  
			//URL da PayPal para redirecionamento, não deve ser modificada
			$paypalURL = 'https://www.paypal.com/cgi-bin/webscr';
		}

		if($s[0]->valortotal == $cancela_valortoral){
			$requestNvp = array(
			    'USER' => $user,
			    'PWD' => $pswd,
			    'SIGNATURE' => $signature,
			  
				'METHOD'=> 'RefundTransaction',
			    'VERSION' => '108',
	  
			    'TRANSACTIONID' => $tid,
			    'REFUNDTYPE' => 'Full'
				);
		}else{
			$requestNvp = array(
			    'USER' => $user,
			    'PWD' => $pswd,
			    'SIGNATURE' => $signature,
			  
				'METHOD'=> 'RefundTransaction',
			    'VERSION' => '108',
	  
			    'REFUNDTYPE' => 'Partial',
			    'AMT' => $cancela_valortoral,
			    'CURRENCYCODE' => 'BRL'
				);
		}		  
		  
		//Envia a requisição e obtém a resposta da PayPal
		$responseNvp = $this->sendNvpRequest($requestNvp, $sandbox);
                                    
        if(isset($responseNvp['ACK']) && $responseNvp['ACK'] == 'Success'){
                                
            if($this->modelo->cancela($cancela_valortoral)){
                $retorno['mensagem'] = 'Transação de cancelamtno efetuado pela operadora.';
                $retorno['resultado'] = true;
            }else{
                $retorno['mensagem'] = 'O cancelamento foi processado com sucesso. Mas houve um erro ao tentar cancelar o pedido, por favor contato o administrador do sistema.';
                $retorno['resultado'] = false;
            }
        }else{

            $retorno['mensagem'] = "Transação de cancelamtno não efetuado pela operadora.<br/>";
            $retorno['resultado'] = false;
        }       
		//$retorno['mensagem'] .= $string." - ".$cancela_valortoral." status:".$xml->status;
        echo json_encode($retorno);
    } 

	function sendNvpRequest(array $requestNvp, $sandbox = false)
	{
		//Endpoint da API
		$apiEndpoint  = 'https://api-3t.' . ($sandbox? 'sandbox.': null);
		$apiEndpoint .= 'paypal.com/nvp';

		//Executando a operação
		$curl = curl_init();
	  
		curl_setopt($curl, CURLOPT_URL, $apiEndpoint);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($requestNvp));
	  
		$response = urldecode(curl_exec($curl));
	  
		curl_close($curl);
	  
		//Tratando a resposta
		$responseNvp = array();
	  
		if (preg_match_all('/(?<name>[^\=]+)\=(?<value>[^&]+)&?/', $response, $matches)) {
			foreach ($matches['name'] as $offset => $name) {
				$responseNvp[$name] = $matches['value'][$offset];
			}
		}
	  	
		//Verificando se deu tudo certo e, caso algum erro tenha ocorrido,
		//gravamos um log para depuração.
		if (isset($responseNvp['ACK']) && $responseNvp['ACK'] != 'Success') {
			for ($i = 0; isset($responseNvp['L_ERRORCODE' . $i]); ++$i) {
				$message = sprintf("PayPal NVP %s[%d]: %s\n",
								   $responseNvp['L_SEVERITYCODE' . $i],
								   $responseNvp['L_ERRORCODE' . $i],
								   $responseNvp['L_LONGMESSAGE' . $i]);
	  
				error_log($message);
			}
		}
	  
		return $responseNvp;
	}

   function baixa(){
   	  error_reporting(E_ALL);
		  ini_set("display_errors", 1 );
        $this->my_acesso->token();
        $this->load->model('pedidomodel','modelo');
        if($this->modelo->baixa()){
            $retorno['mensagem'] = 'Baixa de pagamento efetuada com sucesso.';
            $retorno['resultado'] = true;
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar efetuar baixa.';
				$retorno['resultado'] = false;
        }

        echo json_encode($retorno);
    } 
    
    function receberpagamento(){
   	  error_reporting(E_ALL);
		  ini_set("display_errors", 1 );
        $this->my_acesso->token();
        $this->load->model('pedidomodel','modelo');
        if($this->modelo->receberpagamento()){
            $retorno['mensagem'] = 'Recebimento de pagamento efetuada com sucesso.';
            $retorno['resultado'] = true;
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar efetuar pagamento.';
				$retorno['resultado'] = false;
        }

        echo json_encode($retorno);
    }
    
    function confirmapag(){
        $this->my_acesso->token();
        $this->load->model('pedidomodel','modelo');
        $retorno['id'] = $this->modelo->confirmapag();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Dados foram salvos com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar salvar.';
        }
        echo json_encode($retorno);
    }
	
    public function gerarCortesia(){
        $this->my_acesso->token();
        $this->load->model('pedidomodel','modelo');
        $retorno['id'] = $this->modelo->gerarCortesia();
        //echo $retorno;
        if($retorno['id']){
            $retorno['mensagem'] = 'Cortesia foram gerados com sucesso.';
        }else{
            $retorno['mensagem'] = 'Houve um erro ao tentar gerar os tickets de cortesia.';
        }
        echo json_encode($retorno);
    }
}

